/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.thrifthelper;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.log4j.Logger;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import org.openslx.bwlp.thrift.iface.MasterServer;
import org.openslx.bwlp.thrift.iface.SatelliteServer;
import org.openslx.thrifthelper.ThriftHandler;
import org.openslx.util.Util;

public class ThriftManager<T> {
    private static final Logger LOGGER = Logger.getLogger(ThriftManager.class);
    private final T client;
    private static ThriftManager<MasterServer.Iface> masterManager = null;
    private static ThriftManager<SatelliteServer.Iface> satelliteManager = null;
    private static ErrorCallback satErrorCallback = null;
    private static ErrorCallback masterErrorCallback = null;

    private ThriftManager(Class<T> ifClazz, Class<? extends TServiceClient> clientClazz, ThriftHandler.WantClientCallback<? extends TServiceClient> internalCallback, ErrorCallback errorCb) {
        this.client = Proxy.newProxyInstance(ifClazz.getClassLoader(), new Class[]{ifClazz}, new ThriftHandler<TServiceClient>(clientClazz, internalCallback, errorCb));
    }

    public static synchronized boolean setMasterServerAddress(final SSLContext ctx, final String host, final int port, final int timeout) {
        if (masterManager != null) {
            LOGGER.error("Master server address already set.");
            return false;
        }
        if (host.isEmpty()) {
            LOGGER.error("Given address is empty.");
            return false;
        }
        masterManager = new ThriftManager<MasterServer.Iface>(MasterServer.Iface.class, MasterServer.Client.class, (ThriftHandler.WantClientCallback<? extends TServiceClient>)new ThriftHandler.WantClientCallback<MasterServer.Client>(){

            @Override
            public MasterServer.Client getNewClient() {
                return ThriftManager.getNewMasterClient(ctx, host, port, timeout);
            }
        }, new ErrorCallback(){

            @Override
            public boolean thriftError(int failCount, String method, Throwable t) {
                return masterErrorCallback != null && masterErrorCallback.thriftError(failCount, method, t);
            }
        });
        return true;
    }

    public static synchronized boolean setSatelliteAddress(final SSLContext ctx, final String host, final int port, final int timeout) {
        if (satelliteManager != null) {
            LOGGER.error("Satellite server address already set.");
            return false;
        }
        if (host.isEmpty()) {
            LOGGER.error("Given address is empty.");
            return false;
        }
        satelliteManager = new ThriftManager<SatelliteServer.Iface>(SatelliteServer.Iface.class, SatelliteServer.Client.class, (ThriftHandler.WantClientCallback<? extends TServiceClient>)new ThriftHandler.WantClientCallback<SatelliteServer.Client>(){

            @Override
            public SatelliteServer.Client getNewClient() {
                return ThriftManager.getNewSatelliteClient(ctx, host, port, timeout);
            }
        }, new ErrorCallback(){

            @Override
            public boolean thriftError(int failCount, String method, Throwable t) {
                return satErrorCallback != null && satErrorCallback.thriftError(failCount, method, t);
            }
        });
        return true;
    }

    public static SatelliteServer.Iface getSatClient() {
        if (satelliteManager == null) {
            LOGGER.error("Satellite server adress was not set prior to getting the client. Use setMasterServerAddress(<addr>).");
            return null;
        }
        return (SatelliteServer.Iface)ThriftManager.satelliteManager.client;
    }

    public static MasterServer.Iface getMasterClient() {
        if (masterManager == null) {
            LOGGER.error("Master server adress was not set prior to getting the client. Use setMasterServerAddress(<addr>).");
            return null;
        }
        return (MasterServer.Iface)ThriftManager.masterManager.client;
    }

    public static synchronized void setMasterErrorCallback(ErrorCallback cb) {
        masterErrorCallback = cb;
    }

    public static synchronized void setSatelliteErrorCallback(ErrorCallback cb) {
        satErrorCallback = cb;
    }

    public static MasterServer.Client getNewMasterClient(SSLContext ctx, String address, int port, int timeout) {
        TProtocol protocol = ThriftManager.newTransport(ctx, address, port, timeout);
        if (protocol == null) {
            return null;
        }
        return new MasterServer.Client(protocol);
    }

    public static SatelliteServer.Client getNewSatelliteClient(SSLContext ctx, String address, int port, int timeout) {
        TProtocol protocol = ThriftManager.newTransport(ctx, address, port, timeout);
        if (protocol == null) {
            return null;
        }
        return new SatelliteServer.Client(protocol);
    }

    private static TProtocol newTransport(SSLContext ctx, String host, int port, int timeout) {
        try {
            Socket socket = null;
            try {
                socket = ctx == null ? SocketFactory.getDefault().createSocket() : ctx.getSocketFactory().createSocket();
                socket.connect(new InetSocketAddress(host, port), 4000);
                socket.setSoTimeout(timeout);
            }
            catch (IOException e) {
                if (socket != null) {
                    Util.safeClose(socket);
                }
                throw new TTransportException(e);
            }
            TSocket tsock = new TSocket(socket);
            return new TBinaryProtocol(new TFramedTransport(tsock));
        }
        catch (TTransportException e) {
            LOGGER.error("Could not open transport to thrift server at " + host + ":" + port, e);
            return null;
        }
    }

    public static interface ErrorCallback {
        public boolean thriftError(int var1, String var2, Throwable var3);
    }
}

