/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer;

public class FileRange {
    public final long startOffset;
    public final long endOffset;

    public FileRange(long startOffset, long endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public int getLength() {
        return (int)(this.endOffset - this.startOffset);
    }

    public boolean contains(long startOffset, long endOffset) {
        return this.startOffset <= startOffset && this.endOffset >= endOffset;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof FileRange)) {
            return false;
        }
        FileRange o = (FileRange)other;
        return o.startOffset == this.startOffset && o.endOffset == this.endOffset;
    }

    public int hashCode() {
        return (int)this.startOffset ^ Integer.rotateLeft((int)this.endOffset, 16) ^ (int)(this.startOffset >> 32);
    }
}

