/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ResourceLoader {
    private static final Logger LOGGER = Logger.getLogger(ResourceLoader.class);
    private static final Map<Icon, ImageIcon> iconCache = new HashMap<Icon, ImageIcon>();

    public static ImageIcon getIcon(String path, String description) {
        URL url = ResourceLoader.class.getResource(path);
        if (url == null) {
            LOGGER.error("Resource not found: " + path);
        } else {
            try {
                return new ImageIcon(url, description);
            }
            catch (Exception e) {
                LOGGER.error("Resource not loadable: " + path);
            }
        }
        try {
            return ResourceLoader.errorIcon("Invalid Resource: " + path);
        }
        catch (Throwable t) {
            return new ImageIcon();
        }
    }

    public static Icon getIcon(String path, String description, int maxHeight, Component context) {
        ImageIcon icon = ResourceLoader.getIcon(path, description);
        return ResourceLoader.getScaledIcon(icon, maxHeight, context);
    }

    public static ImageIcon getIcon(String path) {
        return ResourceLoader.getIcon(path, path);
    }

    private static ImageIcon errorIcon(String errorText) {
        Font font = new Font("Tahoma", 0, 20);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        Rectangle2D bounds = font.getStringBounds(errorText, frc);
        int w = (int)bounds.getWidth();
        int h = (int)bounds.getHeight();
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.RED);
        g.setFont(font);
        g.drawString(errorText, (float)bounds.getX(), (float)(-bounds.getY()));
        g.dispose();
        return new ImageIcon(image, "ERROR");
    }

    public static String getTextFile(String path) {
        String fileContent = null;
        try (InputStream stream = ResourceLoader.class.getResourceAsStream(path);){
            fileContent = IOUtils.toString(stream, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("IO error while trying to load resource '" + path + "'. See trace: ", e);
        }
        if (fileContent != null) {
            return fileContent;
        }
        return "Resource '" + path + "' not found.";
    }

    public static InputStream getStream(String path) {
        return ResourceLoader.class.getResourceAsStream(path);
    }

    public static Icon getScaledIcon(Icon icon, int height, Component context) {
        float tHeight;
        if (icon == null) {
            return null;
        }
        ImageIcon cached = iconCache.get(icon);
        if (cached != null && cached.getIconHeight() == height) {
            return cached;
        }
        float iHeight = icon.getIconHeight();
        if (iHeight <= (tHeight = (float)height)) {
            return icon;
        }
        BufferedImage image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        icon.paintIcon(context, g, 0, 0);
        ImageIcon scaledIcon = new ImageIcon(image.getScaledInstance((int)((float)icon.getIconWidth() * (tHeight / iHeight)), (int)tHeight, 4));
        iconCache.put(icon, scaledIcon);
        return scaledIcon;
    }
}

