/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.util;

import java.util.Date;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openslx.bwlp.thrift.iface.Location;
import org.openslx.bwlp.thrift.iface.NetShareAuth;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.bwlp.thrift.iface.Organization;
import org.openslx.bwlp.thrift.iface.UserInfo;

public class FormatHelper {
    private static final char THIN_SP = '\u202f';
    private static final DateTimeFormatter shortDateFormatter = DateTimeFormat.forPattern("dd.MM.yy HH:mm");
    private static final DateTimeFormatter longDateFormatter = DateTimeFormat.forPattern("dd.MM.yyyy HH:mm:ss");

    public static String shortDate(long timestamp) {
        if (timestamp == 0L) {
            return "???";
        }
        return shortDateFormatter.print(timestamp * 1000L);
    }

    public static String shortDate(Date date) {
        return FormatHelper.shortDate(date.getTime() / 1000L);
    }

    public static String longDate(long timestamp) {
        if (timestamp == 0L) {
            return "???";
        }
        return longDateFormatter.print(timestamp * 1000L);
    }

    public static String longDate(Date date) {
        return FormatHelper.longDate(date.getTime() / 1000L);
    }

    public static String userName(UserInfo user) {
        if (user == null) {
            return "<null>";
        }
        return user.getLastName() + ", " + user.getFirstName();
    }

    public static String osName(OperatingSystem os) {
        if (os == null) {
            return "Unknown";
        }
        return os.getOsName();
    }

    public static String bytes(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return String.valueOf(bytes) + '\u202f' + "B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPEZY" : "KMGTPEZY").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f\u202f%sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String formatMilliseconds(long ms, boolean withSeconds) {
        String ret = "";
        long seconds = ms / 1000L;
        if (seconds >= 31536000L) {
            long years = seconds / 31536000L;
            ret = Long.toString(years) + '\u202f';
            ret = years == 1L ? ret + "Jahr" : ret + "Jahre";
            seconds -= years * 86400L * 365L;
        }
        if (seconds >= 86400L) {
            long days = seconds / 86400L;
            if (!ret.isEmpty()) {
                ret = ret + ", ";
            }
            ret = ret + Long.toString(days) + '\u202f';
            ret = days == 1L ? ret + "Tag" : ret + "Tage";
            seconds -= days * 86400L;
        }
        if (!ret.isEmpty()) {
            ret = ret + ", ";
        }
        if (withSeconds) {
            return ret + String.format("%02d:%02d:%02d", seconds / 3600L, seconds % 3600L / 60L, seconds % 60L);
        }
        return ret + String.format("%02d:%02d", seconds / 3600L, seconds % 3600L / 60L);
    }

    public static String daysTil(long timestamp) {
        long minutesLeft = (timestamp * 1000L - System.currentTimeMillis()) / 60000L;
        if (minutesLeft <= 0L) {
            return "-";
        }
        if (minutesLeft < 60L) {
            return new String(minutesLeft + " Minute(n)");
        }
        long hoursLeft = minutesLeft / 60L;
        if (hoursLeft < 24L) {
            return new String(hoursLeft + " Stunde(n)");
        }
        long daysLeft = hoursLeft / 24L;
        if (daysLeft < 14L) {
            return new String(daysLeft + " Tag(e)");
        }
        return FormatHelper.longDate(timestamp);
    }

    public static String locName(Location location) {
        if (location == null) {
            return "Unknown";
        }
        return location.getLocationName();
    }

    public static String orgName(Organization org) {
        if (org == null) {
            return "Unknown";
        }
        return org.getDisplayName();
    }

    public static String netShareAuthName(NetShareAuth auth) {
        if (auth == null) {
            return "Unknown";
        }
        switch (auth) {
            case LOGIN_USER: {
                return "Angemeldeter Nutzer";
            }
            case OTHER_USER: {
                return "Spezifischer Nutzer";
            }
        }
        return auth.toString();
    }
}

