/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.log4j.Logger;
import org.openslx.dozmod.App;
import org.openslx.dozmod.Branding;
import org.openslx.util.Json;

public class ClientVersion {
    private static final Logger LOGGER = Logger.getLogger(ClientVersion.class);
    private static long localRevisionTime = 0L;
    private static long remoteRevisionTime = 0L;
    private static String localRevision = "???";
    private static String remoteRevision = "???";
    private static String changelog = "???";
    private static Thread remoteThread = null;

    public static String getLocalRevision() {
        return localRevision;
    }

    public static long getLocalRevTimestamp() {
        return localRevisionTime;
    }

    public static String getRemoteRevision() {
        ClientVersion.waitRemote();
        return remoteRevision;
    }

    public static long getRemoteRevTimestamp() {
        ClientVersion.waitRemote();
        return remoteRevisionTime;
    }

    public static String getChangelog() {
        ClientVersion.waitRemote();
        return changelog;
    }

    public static boolean isNewest() {
        ClientVersion.waitRemote();
        if (localRevisionTime == 0L || remoteRevisionTime == 0L) {
            return true;
        }
        return localRevisionTime >= remoteRevisionTime;
    }

    private static void loadLocalVersion() {
        Attributes attributes;
        Manifest manifest;
        block24: {
            Class<ClientVersion> clazz = ClientVersion.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                return;
            }
            String manifestPath = classPath.replaceAll("![^!]*$", "") + "!/META-INF/MANIFEST.MF";
            manifest = null;
            try (InputStream stream = new URL(manifestPath).openStream();){
                manifest = new Manifest(stream);
            }
            catch (Exception e) {
                if (manifest != null) break block24;
                LOGGER.error("Could not open MANIFEST", e);
                return;
            }
        }
        if ((attributes = manifest.getMainAttributes()) == null) {
            return;
        }
        String manifestRev = null;
        String manifestRevTime = null;
        try {
            manifestRev = attributes.getValue("Build-Revision");
        }
        catch (Exception e) {
            LOGGER.warn("Error while reading revision: ", e);
        }
        try {
            manifestRevTime = attributes.getValue("Build-Revision-Timestamp");
        }
        catch (Exception e) {
            LOGGER.warn("Error while reading timestamp: ", e);
        }
        if (manifestRev != null) {
            localRevision = manifestRev;
        }
        if (manifestRevTime != null) {
            try {
                localRevisionTime = Long.valueOf(manifestRevTime) / 1000L;
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Build timestamp is not a number!", e);
            }
        }
    }

    private static void loadRemoteVersion(final String urlString) {
        remoteThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String json;
                block14: {
                    App.waitForInit();
                    json = null;
                    try (InputStream reader = new URL(urlString).openStream();){
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        buffer.write(reader);
                        buffer.close();
                        json = new String(buffer.toByteArray(), StandardCharsets.UTF_8);
                    }
                    catch (Exception e) {
                        if (json != null) break block14;
                        LOGGER.error("Could not fetch remote version", e);
                        return;
                    }
                }
                VersionQuery query = Json.deserialize(json, VersionQuery.class);
                remoteRevision = query.revision;
                remoteRevisionTime = query.timestamp;
                changelog = query.changelog;
            }
        });
        remoteThread.start();
    }

    private static synchronized void waitRemote() {
        if (remoteThread == null) {
            return;
        }
        try {
            remoteThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        remoteThread = null;
    }

    public static void createJson(String name) throws IOException {
        String line;
        ClientVersion.loadLocalVersion();
        if (localRevisionTime == 0L) {
            throw new RuntimeException("Missing manifest/data in jar: No revision time found");
        }
        if (localRevision == null || localRevision.isEmpty()) {
            throw new RuntimeException("Missing manifest/data in jar: No commit hash found");
        }
        System.out.println("Please enter change log. To finish, put a '.' on a single line");
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while ((line = br.readLine()) != null && !line.equals(".")) {
            sb.append(line);
            sb.append('\n');
        }
        VersionQuery vq = new VersionQuery();
        vq.timestamp = localRevisionTime;
        vq.revision = localRevision;
        vq.changelog = sb.toString();
        String data = Json.serialize(vq);
        FileUtils.writeStringToFile(new File(name), data, StandardCharsets.UTF_8);
        System.out.println();
        System.out.println("Created json file at " + name);
        System.out.println("This build is using Thrift RPC interface version >> 5 <<");
        System.out.println();
    }

    static {
        ClientVersion.loadLocalVersion();
        ClientVersion.loadRemoteVersion("https://" + Branding.getMasterServerAddress() + "/dozmod/" + 5L + "/version.json");
    }

    static class VersionQuery {
        long timestamp;
        String revision;
        String changelog;

        VersionQuery() {
        }
    }
}

