/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift;

import java.awt.Component;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.AuthorizationError;
import org.openslx.bwlp.thrift.iface.InvocationError;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TInvalidDateParam;
import org.openslx.bwlp.thrift.iface.TInvocationException;
import org.openslx.bwlp.thrift.iface.TNotFoundException;
import org.openslx.bwlp.thrift.iface.TTransferRejectedException;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.MessageType;

public class ThriftError {
    private static final String[] ignoredMethods = new String[]{"ping", "getStatus", "updateBlockHashes", "cancelUpload", "cancelDownload"};

    public static void showMessage(final Component parent, Logger logger, TException ex, String messageText) {
        if (ex instanceof TNotFoundException) {
            messageText = messageText + "\n\nNicht gefunden";
        } else if (ex instanceof TAuthorizationException) {
            String reason = ThriftError.getString(((TAuthorizationException)ex).getNumber());
            messageText = messageText + "\n\nZugriff verweigert: " + reason + "\n" + ex.getMessage();
        } else {
            messageText = ex instanceof TInvocationException ? messageText + "\n\nDer Funktionsaufruf konnte nicht durchgef\u00fchrt werden: " + ThriftError.getString(((TInvocationException)ex).getNumber()) + "\n" + ex.getMessage() : (ex instanceof TInvalidDateParam ? messageText + "\n\nEin angegebenes Datum ist ung\u00fcltig:\n" + ex.getMessage() : (ex instanceof TTransferRejectedException ? messageText + "\n\nDie Transferanfrage wurde vom Server abgelehnt:\n" + ex.getMessage() : messageText + "\n\nUnerwartete Ausnahme " + ex.getClass().getSimpleName() + " ist aufgetreten."));
        }
        if (logger != null) {
            logger.warn("A thrift call raised an exception", ex);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            Gui.showMessageBox(parent, messageText, MessageType.ERROR, null, null);
            return;
        }
        final String msg = messageText;
        Gui.asyncExec(new Runnable(){

            @Override
            public void run() {
                Gui.showMessageBox(parent, msg, MessageType.ERROR, null, null);
            }
        });
    }

    private static String getString(InvocationError error) {
        if (error == null) {
            return "Interner serverseitiger Fehler";
        }
        switch (error) {
            case INTERNAL_SERVER_ERROR: {
                return "Interner serverseitiger Fehler";
            }
            case INVALID_DATA: {
                return "Ein Parameter hat einen ung\u00fcltigen Wert";
            }
            case INVALID_SHARE_MODE: {
                return "Ung\u00fcltiger Share-Mode";
            }
            case MISSING_DATA: {
                return "Ein Parameter fehlt (null?)";
            }
            case UNKNOWN_IMAGE: {
                return "Unbekannte VM/Image";
            }
            case UNKNOWN_LECTURE: {
                return "Unbekannte Veranstaltung";
            }
            case UNKNOWN_USER: {
                return "Unbekannter Benutzer";
            }
        }
        return "Unbekannter Fehlercode: " + error.toString();
    }

    public static String getString(AuthorizationError error) {
        if (error == null) {
            return "(AuthorizationError=null)";
        }
        switch (error) {
            case ACCOUNT_SUSPENDED: {
                return "Das Benutzerkonto ist gesperrt";
            }
            case BANNED_NETWORK: {
                return "Das Netzwerk, aus dem Sie operieren, ist gesperrt";
            }
            case CHALLENGE_FAILED: {
                return "Challenge fehlgeschlagen";
            }
            case GENERIC_ERROR: {
                return "Generischer Fehler";
            }
            case INVALID_CREDENTIALS: {
                return "Ung\u00fcltige Zugangsdaten\nStellen Sie sicher, dass Benutzername und Passwort korrekt sind";
            }
            case INVALID_KEY: {
                return "Ung\u00fcltiger Schl\u00fcssel";
            }
            case INVALID_ORGANIZATION: {
                return "Ung\u00fcltige oder unbekannte Organisation";
            }
            case INVALID_TOKEN: {
                return "Ung\u00fcltiges Sitzungstoken";
            }
            case NOT_AUTHENTICATED: {
                return "Nicht authentifiziert";
            }
            case NO_PERMISSION: {
                return "Keine ausreichenden Berechtigungen";
            }
            case ORGANIZATION_SUSPENDED: {
                return "Ihre zugeh\u00f6rige Organisation ist gesperrt";
            }
        }
        return "Unbekannter Fehlercode: " + error.toString();
    }

    public static boolean failSilently(String methodName) {
        for (int i = 0; i < ignoredMethods.length; ++i) {
            if (!ignoredMethods[i].equals(methodName)) continue;
            return true;
        }
        return false;
    }
}

