/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard.page;

import java.util.Map;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.LecturePermissions;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.layout.LectureCustomPermissionPageLayout;
import org.openslx.dozmod.state.LectureWizardState;
import org.openslx.dozmod.thrift.Session;

public class LectureCustomPermissionPage
extends LectureCustomPermissionPageLayout {
    private static final Logger LOGGER = Logger.getLogger(LectureCustomPermissionPage.class);
    private boolean initDone = false;
    private LectureWizardState state = null;

    public LectureCustomPermissionPage(Wizard wizard, LectureWizardState state) {
        super(wizard);
        this.state = state;
        this.chkPermissionEdit.setSelected(state.defaultPermissions.edit);
        this.chkPermissionAdmin.setSelected(state.defaultPermissions.admin);
        this.setPageComplete(true);
    }

    @Override
    protected void onPageEnter() {
        if (!this.initDone) {
            this.lectureCustomPermissionManager.initPanel(this.state.permissionMap, this.state.defaultPermissions, Session.getUserId());
            this.initDone = true;
        }
    }

    @Override
    protected boolean wantNextOrFinish() {
        LOGGER.debug("Saving permissions to state ...");
        this.state.defaultPermissions.edit = this.chkPermissionEdit.isSelected();
        this.state.defaultPermissions.admin = this.chkPermissionAdmin.isSelected();
        Map<String, LecturePermissions> newPermissionMap = this.lectureCustomPermissionManager.getPermissions();
        if (newPermissionMap == null || newPermissionMap.isEmpty()) {
            return true;
        }
        this.state.permissionMap = newPermissionMap;
        return true;
    }
}

