/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard;

import java.awt.Window;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.ImageBaseWrite;
import org.openslx.bwlp.thrift.iface.ImageVersionWrite;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.WizardPage;
import org.openslx.dozmod.gui.wizard.page.ImageCustomPermissionPage;
import org.openslx.dozmod.gui.wizard.page.ImageMetaDataPage;
import org.openslx.dozmod.gui.wizard.page.ImageUploadPage;
import org.openslx.dozmod.gui.wizard.page.ImageUploadSummaryPage;
import org.openslx.dozmod.state.UploadWizardState;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.ThriftError;
import org.openslx.dozmod.thrift.UploadInitiator;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

public class ImageCreationWizard
extends Wizard
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(ImageCreationWizard.class);
    private final UploadWizardState state = new UploadWizardState();
    protected ImageUploadPage imageUploadPage;
    protected ImageMetaDataPage imageMetaDataPage;
    protected ImageCustomPermissionPage imageCustomPermissionPage;
    private boolean baseWritten = false;
    private boolean permissionsWritten = false;

    public ImageCreationWizard(Window parent) {
        super(parent);
        this.state.defaultPermissions = Session.getSatelliteConfig().defaultImagePermissions;
        this.imageUploadPage = new ImageUploadPage(this, this.state, null);
        this.imageMetaDataPage = new ImageMetaDataPage((Wizard)this, this.state);
        this.imageCustomPermissionPage = new ImageCustomPermissionPage((Wizard)this, this.state);
        this.addPage(this.imageUploadPage);
        this.addPage(this.imageMetaDataPage);
        this.addPage(this.imageCustomPermissionPage);
    }

    @Override
    public String getWindowTitle() {
        return "Neue VM erzeugen";
    }

    @Override
    public boolean wantFinish() {
        if (!this.isStateValid()) {
            Gui.showMessageBox(this, "Ein interner Fehler ist aufgetreten.\n\nDetails in der Logdatei.", MessageType.ERROR, null, null);
            return false;
        }
        if (!this.baseWritten) {
            try {
                ThriftActions.updateImageBase(this.state.uuid, this.imageBaseWriteFromState());
            }
            catch (TException e) {
                ThriftError.showMessage(null, LOGGER, e, "Konnte die Metadaten der VM nicht auf dem Satelliten speichern!");
                return false;
            }
            this.baseWritten = true;
        }
        if (!this.permissionsWritten) {
            if (this.state.permissionMap != null && !this.state.permissionMap.isEmpty()) {
                try {
                    ThriftActions.writeImagePermissions(this.state.uuid, this.state.permissionMap);
                }
                catch (TException e) {
                    Gui.showMessageBox(this, "Konnte die Berechtigungen nicht auf dem Satelliten speichern!", MessageType.ERROR, null, null);
                    ThriftActions.deleteImageBase(JOptionPane.getFrameForComponent(this), this.state.uuid);
                    return false;
                }
            }
            this.permissionsWritten = true;
        }
        this.state.upload.startUpload(new UploadInitiator.GotUploadTokenCallback(){

            @Override
            public void fire() {
                block2: {
                    try {
                        ThriftActions.updateImageVersion(((ImageCreationWizard)ImageCreationWizard.this).state.upload.getToken(), new ImageVersionWrite(((ImageCreationWizard)ImageCreationWizard.this).state.isRestricted));
                    }
                    catch (TException e) {
                        if (!((ImageCreationWizard)ImageCreationWizard.this).state.isRestricted) break block2;
                        Gui.showMessageBox(null, "Unerwarteter Fehler beim Setzen der Option 'Enth\u00e4lt lizenzpflichtige Software' f\u00fcr diese Virtuelle Maschine.", MessageType.WARNING, LOGGER, e);
                    }
                }
            }
        });
        return true;
    }

    @Override
    public WizardPage performFinish() {
        return new ImageUploadSummaryPage(this, this.state, true);
    }

    private boolean isStateValid() {
        if (this.state.name == null || this.state.name.isEmpty()) {
            LOGGER.error("No name set in state!");
            return false;
        }
        if (this.state.description == null || this.state.description.isEmpty()) {
            LOGGER.error("No description set in state!");
            return false;
        }
        if (this.state.descriptionFile == null) {
            LOGGER.error("No description file set in state!");
            return false;
        }
        if (!this.state.descriptionFile.canRead()) {
            LOGGER.error(this.state.descriptionFile.getAbsolutePath() + " cannot be read!");
            return false;
        }
        if (this.state.diskFile == null) {
            LOGGER.error("No disk file set in state!");
            return false;
        }
        if (!this.state.diskFile.canRead()) {
            LOGGER.error(this.state.diskFile.getAbsolutePath() + " cannot be read!");
            return false;
        }
        if (this.state.selectedOs == null) {
            LOGGER.error("No OS set in state!");
            return false;
        }
        if (!this.state.selectedOs.isSetOsId()) {
            LOGGER.error("OS has no id: " + this.state.selectedOs.toString());
            return false;
        }
        if (this.state.meta == null) {
            LOGGER.error("No vm meta data set in state!");
            return false;
        }
        if (this.state.defaultPermissions == null) {
            LOGGER.error("No permissions set in state!");
            return false;
        }
        if (this.state.shareMode == null) {
            LOGGER.error("No share mode set in state!");
            return false;
        }
        if (this.state.uuid == null) {
            LOGGER.error("No uuid set in state!");
            return false;
        }
        return true;
    }

    private ImageBaseWrite imageBaseWriteFromState() {
        return new ImageBaseWrite(this.state.name, this.state.description, this.state.selectedOs.getOsId(), this.state.meta.getVirtualizer().getVirtId(), this.state.isTemplate, this.state.defaultPermissions, this.state.shareMode);
    }

    @Override
    protected boolean onCancelRequest() {
        if (this.state.uuid == null) {
            return true;
        }
        boolean confirmed = Gui.showMessageBox(this, "M\u00f6chten Sie den Vorgang wirklich abbrechen?", MessageType.QUESTION_YESNO, null, null);
        if (confirmed) {
            QuickTimer.scheduleOnce(new QuickTimer.Task(){

                @Override
                public void fire() {
                    if (((ImageCreationWizard)ImageCreationWizard.this).state.upload != null) {
                        ((ImageCreationWizard)ImageCreationWizard.this).state.upload.cancelError();
                    }
                    try {
                        ThriftManager.getSatClient().deleteImageBase(Session.getSatelliteToken(), ((ImageCreationWizard)ImageCreationWizard.this).state.uuid);
                    }
                    catch (TException e) {
                        LOGGER.debug("Error canceling upload on sat: ", e);
                    }
                }
            });
        }
        return confirmed;
    }

    @Override
    public boolean wantConfirmQuit() {
        return this.state.uuid != null;
    }

    @Override
    public void escapePressed() {
        this.doCancel();
    }
}

