/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window.layout;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.helper.GridManager;

public abstract class GenericNoticeWindowLayout
extends JDialog {
    protected String info = "Bitte lesen und best\u00e4tigen Sie folgende rechtliche Hinweise:";
    protected JTextArea notice;
    protected JScrollPane disclaimerPanel;
    protected String checkboxText = "Ja, ich akzeptiere die Vereinbarung. Benachrichtigung nicht mehr anzeigen.";
    private static String title = Branding.getApplicationName();
    private static String noticeLabel = "Hinweis";
    private static String continueButtonLabel = "Weiter";
    protected final JCheckBox chkAgreeBox;
    protected final JButton btnContinue;

    public GenericNoticeWindowLayout(Frame modalParent) {
        super((Window)modalParent, title, modalParent != null ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.setLayout(new BorderLayout());
        JPanel borderPanel = new JPanel();
        borderPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(borderPanel);
        QLabel noticePanel = new QLabel();
        noticePanel.setBorder(BorderFactory.createTitledBorder(noticeLabel));
        noticePanel.setText(this.info);
        this.notice = new JTextArea(30, 20);
        this.notice.setEditable(false);
        this.notice.setLineWrap(true);
        this.notice.setWrapStyleWord(true);
        this.disclaimerPanel = new JScrollPane(this.notice, 22, 31);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        this.chkAgreeBox = new JCheckBox(this.checkboxText);
        this.chkAgreeBox.setEnabled(false);
        buttonPanel.add(this.chkAgreeBox);
        buttonPanel.add(Box.createHorizontalGlue());
        this.btnContinue = new JButton(continueButtonLabel);
        this.btnContinue.setEnabled(false);
        buttonPanel.add(this.btnContinue);
        GridManager grid = new GridManager(borderPanel, 1);
        grid.add(noticePanel).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.add(this.disclaimerPanel).fill(true, true).expand(true, true);
        grid.nextRow();
        grid.add(buttonPanel).fill(true, false).expand(true, false);
        grid.finish(false);
        this.pack();
        if (modalParent != null) {
            Gui.centerShellOverShell(modalParent, this);
        }
    }

    public void setNoticeText(String text) {
        if (this.notice != null) {
            this.notice.setText(text);
            this.notice.setCaretPosition(0);
        }
    }
}

