/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.VirtConfigEditorWindow;
import org.openslx.dozmod.gui.window.layout.VirtDropDownConfigEditorWindowLayout;
import org.openslx.dozmod.thrift.ImageDetailsActions;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.util.ThriftUtil;
import org.openslx.util.XmlHelper;
import org.openslx.util.vm.VboxMetaData;
import org.openslx.util.vm.VmMetaData;

public class VirtDropDownConfigEditorWindow
extends VirtDropDownConfigEditorWindowLayout
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(VirtDropDownConfigEditorWindow.class);
    private final String imageVersionId;
    private final String originalMachineDescription;
    private final VirtDropDownConfigEditorWindow me = this;
    private final VmMetaData<?, ?, ?, ?> meta;
    private final ImageDetailsActions actionHandler;

    protected VirtDropDownConfigEditorWindow(Window modalParent, final ImageDetailsActions actionHandler, final String imageVersionId, ByteBuffer machineDescription) {
        super(modalParent);
        this.actionHandler = actionHandler;
        this.imageVersionId = imageVersionId;
        VmMetaData<?, ?, ?, ?> metaCandidate = null;
        byte[] machineData = ThriftUtil.unwrapByteBuffer(machineDescription);
        try {
            metaCandidate = VmMetaData.getInstance(MetaDataCache.getOperatingSystems(), machineData, machineData.length);
        }
        catch (IOException e) {
            LOGGER.error("Could not get VmMetaData instance from given machine description: ", e);
        }
        this.meta = metaCandidate;
        if (metaCandidate == null) {
            this.originalMachineDescription = null;
            this.dispose();
            return;
        }
        this.initializeSoundBox(this.meta.getSupportedSoundCards());
        this.initializeDDABox(this.meta.getSupportedDDAccs());
        this.initializeHWVersBox(this.meta.getSupportedHWVersions());
        this.initializeEDTBox(this.meta.getSupportedEthernetDevices());
        this.initializeComboBoxes(this.meta);
        this.cboSound.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VmMetaData.SoundCardType selected = (VmMetaData.SoundCardType)((Object)VirtDropDownConfigEditorWindow.this.cboSound.getSelectedItem());
                VirtDropDownConfigEditorWindow.this.meta.setSoundCard(selected);
                VirtDropDownConfigEditorWindow.this.btnSave.setEnabled(VirtDropDownConfigEditorWindow.this.hasChanged());
            }
        });
        this.cbo3DAcceleration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VmMetaData.DDAcceleration selected = (VmMetaData.DDAcceleration)((Object)VirtDropDownConfigEditorWindow.this.cbo3DAcceleration.getSelectedItem());
                VirtDropDownConfigEditorWindow.this.meta.setDDAcceleration(selected);
                VirtDropDownConfigEditorWindow.this.btnSave.setEnabled(VirtDropDownConfigEditorWindow.this.hasChanged());
            }
        });
        this.cboHWVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VmMetaData.HWVersion selected = (VmMetaData.HWVersion)((Object)VirtDropDownConfigEditorWindow.this.cboHWVersion.getSelectedItem());
                VirtDropDownConfigEditorWindow.this.meta.setHWVersion(selected);
                VirtDropDownConfigEditorWindow.this.btnSave.setEnabled(VirtDropDownConfigEditorWindow.this.hasChanged());
            }
        });
        this.cboE0VirtDev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VmMetaData.EthernetDevType selected = (VmMetaData.EthernetDevType)((Object)VirtDropDownConfigEditorWindow.this.cboE0VirtDev.getSelectedItem());
                VirtDropDownConfigEditorWindow.this.meta.setEthernetDevType(0, selected);
                VirtDropDownConfigEditorWindow.this.btnSave.setEnabled(VirtDropDownConfigEditorWindow.this.hasChanged());
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtDropDownConfigEditorWindow.this.saveClicked();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtDropDownConfigEditorWindow.this.safeClose();
            }
        });
        this.btnMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentMachineDesc = VirtDropDownConfigEditorWindow.this.meta instanceof VboxMetaData ? XmlHelper.getFormattedXml(new ByteArrayInputStream(VirtDropDownConfigEditorWindow.this.meta.getDefinitionArray())) : ThriftUtil.byteBufferToString(ByteBuffer.wrap(VirtDropDownConfigEditorWindow.this.meta.getDefinitionArray()));
                boolean didSave = VirtConfigEditorWindow.open(VirtDropDownConfigEditorWindow.this.me, actionHandler, imageVersionId, currentMachineDesc, VirtDropDownConfigEditorWindow.this.originalMachineDescription);
                if (didSave) {
                    VirtDropDownConfigEditorWindow.this.dispose();
                }
            }
        });
        this.originalMachineDescription = ThriftUtil.byteBufferToString(machineDescription);
        this.btnSave.setEnabled(false);
    }

    private void initializeComboBoxes(VmMetaData<?, ?, ?, ?> m) {
        try {
            VmMetaData.SoundCardType SCT = m.getSoundCard();
            this.cboSound.setSelectedItem((Object)SCT);
            VmMetaData.DDAcceleration DDA = m.getDDAcceleration();
            this.cbo3DAcceleration.setSelectedItem((Object)DDA);
            VmMetaData.HWVersion HWV = m.getHWVersion();
            this.cboHWVersion.setSelectedItem((Object)HWV);
            VmMetaData.EthernetDevType E0VD = m.getEthernetDevType(0);
            this.cboE0VirtDev.setSelectedItem((Object)E0VD);
        }
        catch (IllegalArgumentException e) {
            Gui.showMessageBox("Sie haben beim letzten Konfigurieren \neinen falschen Eintrag eingespeichert. \nDie VM wird nicht starten!", MessageType.WARNING, null, e);
        }
    }

    private void saveClicked() {
        this.actionHandler.setVirtualizerConfig(this.imageVersionId, ByteBuffer.wrap(this.meta.getDefinitionArray()), new ImageDetailsActions.VirtConfCallback(){

            @Override
            public void virtConfCallback(boolean success) {
                if (success) {
                    VirtDropDownConfigEditorWindow.this.dispose();
                }
            }
        });
    }

    public static void open(Window modalParent, ImageDetailsActions handler, String imageVersionId, ByteBuffer machineDescription) {
        VirtDropDownConfigEditorWindow win = new VirtDropDownConfigEditorWindow(modalParent, handler, imageVersionId, machineDescription);
        win.setVisible(true);
    }

    private boolean hasChanged() {
        return !this.originalMachineDescription.equals(ThriftUtil.byteBufferToString(ByteBuffer.wrap(this.meta.getDefinitionArray())));
    }

    private void safeClose() {
        if (!this.hasChanged() || Gui.showMessageBox(this.me, "Wollen Sie wirklich abbrechen?\nIhre \u00c4nderungen werden verworfen.", MessageType.QUESTION_YESNO, null, null)) {
            this.dispose();
        }
    }

    @Override
    public boolean wantConfirmQuit() {
        return this.hasChanged();
    }

    @Override
    public void escapePressed() {
        this.safeClose();
    }

    public static interface VirtConfigChanged {
        public void virtConfigChanged(String var1);
    }
}

