/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.TextChangeListener;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.layout.VirtConfigEditorWindowLayout;
import org.openslx.dozmod.thrift.ImageDetailsActions;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.util.XmlHelper;
import org.openslx.util.vm.VboxMetaData;
import org.openslx.util.vm.VmMetaData;
import org.openslx.util.vm.VmwareConfig;

public class VirtConfigEditorWindow
extends VirtConfigEditorWindowLayout
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(VirtConfigEditorWindow.class);
    private final String imageVersionId;
    private final String originalMachineDescription;
    private final VirtConfigEditorWindow me = this;
    private final ImageDetailsActions actionHandler;
    private boolean configWasSaved = false;

    protected VirtConfigEditorWindow(Window modalParent, ImageDetailsActions actionHandler, String imageVersionId, String currentMachineDescription, String originalmachineDescription) {
        super(modalParent);
        this.actionHandler = actionHandler;
        this.imageVersionId = imageVersionId;
        this.pnlEditor.getDocument().addDocumentListener(new TextChangeListener(){

            @Override
            public void changed() {
                VirtConfigEditorWindow.this.btnSave.setEnabled(!VirtConfigEditorWindow.this.originalMachineDescription.equals(VirtConfigEditorWindow.this.pnlEditor.getText()));
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtConfigEditorWindow.this.saveClicked();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtConfigEditorWindow.this.safeClose();
            }
        });
        this.originalMachineDescription = XmlHelper.getFormattedXml(new ByteArrayInputStream(originalmachineDescription.getBytes(StandardCharsets.UTF_8)));
        this.pnlEditor.setText(currentMachineDescription);
        this.pnlEditor.setCaretPosition(0);
    }

    private void saveClicked() {
        ByteBuffer toSave;
        String userInput = this.pnlEditor.getText();
        byte[] uiBytes = userInput.getBytes(StandardCharsets.ISO_8859_1);
        Charset cs = VmwareConfig.getCharset(uiBytes, uiBytes.length);
        uiBytes = userInput.getBytes(cs);
        VmMetaData<?, ?, ?, ?> metaCandidate = null;
        try {
            metaCandidate = VmMetaData.getInstance(MetaDataCache.getOperatingSystems(), uiBytes, uiBytes.length);
        }
        catch (IOException e) {
            LOGGER.error("Could not get VmMetaData instance from given machine description: ", e);
        }
        if (metaCandidate == null) {
            this.dispose();
            return;
        }
        byte[] uiBytesFiltered = metaCandidate.getDefinitionArray();
        String userInputFiltered = metaCandidate instanceof VboxMetaData ? XmlHelper.getFormattedXml(new ByteArrayInputStream(uiBytesFiltered)) : new String(uiBytesFiltered, cs);
        TreeSet<String> unfilteredSet = this.stringToTreeSet(userInput);
        TreeSet<String> filteredSet = this.stringToTreeSet(userInputFiltered);
        if (!filteredSet.equals(unfilteredSet)) {
            unfilteredSet.removeAll(filteredSet);
            String errorText = "Invalide Eingaben:\n";
            for (String s : unfilteredSet) {
                errorText = errorText + s + "\n";
            }
            if (!Gui.showMessageBox(errorText = errorText + System.lineSeparator() + "Wollen Sie trotzdem speichern? (Die invaliden Zeilen werden dabei automatisch gel\u00f6scht.)", MessageType.ERROR_RETRY, LOGGER, null)) {
                return;
            }
        }
        if (metaCandidate instanceof VboxMetaData) {
            String unformattedInput = XmlHelper.getUnformattedXml(new ByteArrayInputStream(uiBytesFiltered));
            toSave = ByteBuffer.wrap(unformattedInput.getBytes(cs));
        } else {
            toSave = ByteBuffer.wrap(uiBytesFiltered);
        }
        this.actionHandler.setVirtualizerConfig(this.imageVersionId, toSave, new ImageDetailsActions.VirtConfCallback(){

            @Override
            public void virtConfCallback(boolean success) {
                if (success) {
                    VirtConfigEditorWindow.this.configWasSaved = true;
                    VirtConfigEditorWindow.this.dispose();
                }
            }
        });
    }

    private TreeSet<String> stringToTreeSet(String s) {
        String[] split = s.split("[\\r\\n]+");
        ArrayList<String> splitList = new ArrayList<String>(Arrays.asList(split));
        splitList.removeAll(Arrays.asList("", null));
        TreeSet<String> set = new TreeSet<String>(splitList);
        return set;
    }

    public static boolean open(Window modalParent, ImageDetailsActions handler, String imageVersionId, String currentmachineDescription, String originalMachineDescription) {
        VirtConfigEditorWindow win = new VirtConfigEditorWindow(modalParent, handler, imageVersionId, currentmachineDescription, originalMachineDescription);
        win.setVisible(true);
        return win.configWasSaved;
    }

    private void safeClose() {
        if (this.originalMachineDescription.equals(this.pnlEditor.getText()) || Gui.showMessageBox(this.me, "Ihre \u00c4nderungen, in diesem Fenster, werden verloren gehen, wollen Sie trotzdem abbrechen?", MessageType.QUESTION_YESNO, null, null)) {
            this.dispose();
        }
    }

    @Override
    public boolean wantConfirmQuit() {
        return !this.originalMachineDescription.equals(this.pnlEditor.getText());
    }

    @Override
    public void escapePressed() {
        this.safeClose();
    }

    public static interface VirtConfigChanged {
        public void virtConfigChanged(String var1);
    }
}

