/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultRowSorter;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.TextChangeListener;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.layout.UserListWindowLayout;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.util.QuickTimer;

public class UserListWindow
extends UserListWindowLayout
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(UserListWindow.class);
    private final UserListWindow me = this;
    private String ownerId = null;

    public UserListWindow(Window modalParent, final UserAddedCallback callback, String buttonCaption) {
        super(modalParent, buttonCaption);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                QuickTimer.scheduleOnce(new QuickTimer.Task(){

                    @Override
                    public void fire() {
                        List<UserInfo> cacheList = UserCache.getAll();
                        final ArrayList<UserInfo> userList = new ArrayList<UserInfo>(cacheList.size() - 1);
                        for (UserInfo user : cacheList) {
                            if (UserListWindow.this.ownerId != null && user.getUserId().equals(UserListWindow.this.ownerId)) continue;
                            userList.add(user);
                        }
                        Gui.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                UserListWindow.this.userTable.setData(userList, true);
                                int calcHeight = 150 + userList.size() * 20;
                                calcHeight = calcHeight > 350 ? calcHeight : 350;
                                UserListWindow.this.me.setPreferredSize(Gui.getScaledDimension(450, calcHeight < 600 ? calcHeight : 600));
                                UserListWindow.this.me.pack();
                                UserListWindow.this.userTable.setAutoResizeMode(4);
                            }
                        });
                    }
                });
            }
        });
        this.txtSearch.getDocument().addDocumentListener(new TextChangeListener(){

            @Override
            public void changed() {
                try {
                    ((DefaultRowSorter)UserListWindow.this.userTable.getRowSorter()).setRowFilter(RowFilter.regexFilter("(?i)" + UserListWindow.this.txtSearch.getText(), new int[0]));
                    UserListWindow.this.txtSearch.setForeground(UIManager.getColor("TextField.foreground"));
                }
                catch (IllegalArgumentException ex) {
                    UserListWindow.this.txtSearch.setForeground(Color.RED);
                }
            }
        });
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserInfo user = (UserInfo)UserListWindow.this.userTable.getSelectedItem();
                if (user == null) {
                    return;
                }
                callback.userAdded(user, UserListWindow.this.me);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserListWindow.this.dispose();
            }
        });
        this.getRootPane().setDefaultButton(this.btnConfirm);
        this.userTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UserListWindow.this.btnConfirm.doClick();
                }
            }
        });
        Gui.centerShellOverShell(modalParent, this);
    }

    public static void open(Window modalParent, UserAddedCallback callback, String buttonCaption, String ownerId) {
        UserListWindow win = new UserListWindow(modalParent, callback, buttonCaption);
        win.ownerId = ownerId;
        win.setVisible(true);
    }

    @Override
    public boolean wantConfirmQuit() {
        return false;
    }

    @Override
    public void escapePressed() {
        this.dispose();
    }

    public static interface UserAddedCallback {
        public void userAdded(UserInfo var1, UserListWindow var2);
    }
}

