/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.GenericNoticeWindow;
import org.openslx.dozmod.util.ResourceLoader;

public class PrivacyNoticeWindow
extends GenericNoticeWindow
implements UiFeedback {
    private static final Logger LOGGER = Logger.getLogger(PrivacyNoticeWindow.class);
    final PrivacyNoticeWindow me = this;
    private static String PRIVACY_NOTICE_MD5 = null;
    private static String PRIVACY_NOTICE_CONTENT = null;

    public PrivacyNoticeWindow(Frame modalParent) {
        super(modalParent, PrivacyNoticeWindow.shouldBeShown());
        this.setNoticeText(PRIVACY_NOTICE_CONTENT);
        this.btnContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.setPrivacyAgreement(PRIVACY_NOTICE_MD5);
                PrivacyNoticeWindow.this.me.dispose();
            }
        });
    }

    public static boolean shouldBeShown() {
        return !Config.getPrivacyAgreement().equals(PRIVACY_NOTICE_MD5);
    }

    public static void open(Frame modalParent) {
        new PrivacyNoticeWindow(modalParent).setVisible(true);
    }

    static {
        try (InputStream noticeStream = ResourceLoader.getStream("/txt/privacy_notice");){
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] content = IOUtils.toByteArray(noticeStream);
            md.update(content);
            byte[] md5 = md.digest();
            PRIVACY_NOTICE_CONTENT = new String(content, StandardCharsets.UTF_8);
            PRIVACY_NOTICE_MD5 = DatatypeConverter.printHexBinary((byte[])md5);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            LOGGER.error("Failed to get hash of privacy_notice: ", e);
        }
    }
}

