/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.helper;

import java.awt.Color;

public class ColorUtil {
    private static float[] squared(Color color) {
        float[] vals = color.getRGBComponents(null);
        vals[0] = vals[0] * vals[0];
        vals[1] = vals[1] * vals[1];
        vals[2] = vals[2] * vals[2];
        return vals;
    }

    private static Color sqrt(float ... floatVals) {
        floatVals[0] = (float)Math.sqrt(floatVals[0]);
        floatVals[1] = (float)Math.sqrt(floatVals[1]);
        floatVals[2] = (float)Math.sqrt(floatVals[2]);
        return new Color(floatVals[0], floatVals[1], floatVals[2]);
    }

    public static Color blendFast(Color color1, Color color2, float wc1) {
        float[] c1 = color1.getColorComponents(null);
        float[] c2 = color2.getColorComponents(null);
        float wc2 = 1.0f - wc1;
        return new Color(c1[0] * wc1 + c2[0] * wc2, c1[1] * wc1 + c2[1] * wc2, c1[2] * wc1 + c2[2] * wc2);
    }

    public static Color blend(Color color1, Color color2, float wc1) {
        float[] c1 = ColorUtil.squared(color1);
        float[] c2 = ColorUtil.squared(color2);
        float wc2 = 1.0f - wc1;
        return ColorUtil.sqrt(c1[0] * wc1 + c2[0] * wc2, c1[1] * wc1 + c2[1] * wc2, c1[2] * wc1 + c2[2] * wc2);
    }

    public static Color add(Color color1, Color color2) {
        float[] c1 = ColorUtil.squared(color1);
        float[] c2 = ColorUtil.squared(color2);
        c1[0] = c1[0] + c2[0];
        c1[1] = c1[1] + c2[1];
        c1[2] = c1[2] + c2[2];
        float max = Math.max(Math.max(c1[0], c1[1]), c1[2]);
        if (max > 1.0f) {
            c1[0] = c1[0] / max;
            c1[1] = c1[1] / max;
            c1[2] = c1[2] / max;
        }
        return ColorUtil.sqrt(c1[0], c1[1], c1[2]);
    }

    public static float getBrightness(Color color) {
        float[] a = new float[3];
        color.getRGBColorComponents(a);
        return a[0] * 0.2126f + a[1] * 0.7152f + a[2] * 0.0722f;
    }

    public static float getContrast(Color a, Color b) {
        float val = (ColorUtil.getBrightness(a) + 0.05f) / (ColorUtil.getBrightness(b) + 0.05f);
        if (val < 1.0f) {
            val = 1.0f / val;
        }
        return val;
    }

    public static Color contrastColor(Color color) {
        return new Color(color.getRed() ^ 0x80, color.getGreen() ^ 0x80, color.getBlue() ^ 0x80);
    }
}

