/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control.table;

import org.openslx.bwlp.thrift.iface.ImageVersionDetails;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.FormatHelper;

public class ImageVersionTable
extends ListTable<ImageVersionDetails> {
    public static final ListTable.ListTableColumn COL_CREATED = new ListTable.ListTableColumn("Erstellungszeitpunkt", Long.class);
    public static final ListTable.ListTableColumn COL_EXPIRING = new ListTable.ListTableColumn("Ablaufszeitpunkt", Long.class);
    public static final ListTable.ListTableColumn COL_UPLOADER = new ListTable.ListTableColumn("Ersteller");
    public static final ListTable.ListTableColumn COL_VALID = new ListTable.ListTableColumn("Verwendbar", Boolean.class);
    public static final ListTable.ListTableColumn COL_SIZE = new ListTable.ListTableColumn("Gr\u00f6\u00dfe", Long.class);
    public static final ListTable.ListTableColumn COL_ID = new ListTable.ListTableColumn("Interne ID");

    public ImageVersionTable() {
        super(COL_CREATED, COL_EXPIRING, COL_UPLOADER, COL_VALID, COL_SIZE, COL_ID);
    }

    @Override
    protected Object getValueAtInternal(ImageVersionDetails row, ListTable.ListTableColumn column) {
        if (column == COL_CREATED) {
            return row.getCreateTime();
        }
        if (column == COL_EXPIRING) {
            return row.getExpireTime();
        }
        if (column == COL_UPLOADER) {
            return row.getUploaderId();
        }
        if (column == COL_VALID) {
            return row.isValid;
        }
        if (column == COL_SIZE) {
            return row.getFileSize();
        }
        if (column == COL_ID) {
            return row.getVersionId();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object modelValueToDisplayFormat(Object value, ListTable.ListTableColumn column) {
        if (column == COL_VALID || column == COL_ID) {
            return value;
        }
        if (column == COL_CREATED) {
            return FormatHelper.longDate((Long)value);
        }
        if (column == COL_EXPIRING) {
            return FormatHelper.daysTil((Long)value);
        }
        if (column == COL_UPLOADER) {
            return FormatHelper.userName(UserCache.find((String)value));
        }
        if (column == COL_SIZE) {
            return FormatHelper.bytes((Long)value, false);
        }
        throw new IndexOutOfBoundsException();
    }
}

