/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control.table;

import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.dozmod.gui.control.table.ListTable;
import org.openslx.dozmod.thrift.cache.UserCache;
import org.openslx.dozmod.util.FormatHelper;

public class ImagePermissionTable
extends ListTable<UserImagePermissions> {
    public static final ListTable.ListTableColumn COL_USER = new ListTable.ListTableColumn("Benutzer");
    public static final ListTable.ListTableColumn COL_LINK = new ListTable.ListTableColumn("Verlinken", Boolean.class);
    public static final ListTable.ListTableColumn COL_DOWNLOAD = new ListTable.ListTableColumn("Download", Boolean.class);
    public static final ListTable.ListTableColumn COL_EDIT = new ListTable.ListTableColumn("Bearbeiten", Boolean.class);
    public static final ListTable.ListTableColumn COL_ADMIN = new ListTable.ListTableColumn("Admin", Boolean.class);

    public ImagePermissionTable() {
        super(COL_USER, COL_LINK, COL_DOWNLOAD, COL_EDIT, COL_ADMIN);
    }

    @Override
    protected Object getValueAtInternal(UserImagePermissions row, ListTable.ListTableColumn column) {
        if (column == COL_USER) {
            return FormatHelper.userName(UserCache.find(row.userId));
        }
        if (column == COL_LINK) {
            return row.permissions.link;
        }
        if (column == COL_DOWNLOAD) {
            return row.permissions.download;
        }
        if (column == COL_EDIT) {
            return row.permissions.edit;
        }
        if (column == COL_ADMIN) {
            return row.permissions.admin;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!(aValue instanceof Boolean)) {
            return;
        }
        UserImagePermissions row = (UserImagePermissions)this.getViewRow(rowIndex);
        if (columnIndex == 1) {
            row.permissions.link = (Boolean)aValue;
        }
        if (columnIndex == 2) {
            row.permissions.download = (Boolean)aValue;
        }
        if (columnIndex == 3) {
            row.permissions.edit = (Boolean)aValue;
        }
        if (columnIndex == 4) {
            row.permissions.admin = (Boolean)aValue;
        }
    }

    public static class UserImagePermissions {
        public final String userId;
        public final ImagePermissions permissions;

        public UserImagePermissions(String userId, ImagePermissions permission) {
            this.userId = userId;
            this.permissions = permission;
        }
    }
}

