/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.UIManager;
import org.openslx.bwlp.thrift.iface.UserInfo;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.helper.ColorUtil;
import org.openslx.dozmod.util.DesktopEnvironment;
import org.openslx.dozmod.util.FormatHelper;

public class PersonLabel
extends QLabel {
    private UserInfo user = null;
    private PersonLabelClickEvent callback = defaultCallback;
    private static final Color linkColor = ColorUtil.add(UIManager.getColor("Label.foreground"), new Color(0.0f, 0.0f, 0.9f));
    private static final PersonLabelClickEvent defaultCallback = new PersonLabelClickEvent(){

        @Override
        public void clicked(UserInfo user) {
            if (user == null || user.eMail == null) {
                return;
            }
            DesktopEnvironment.sendMail(user.eMail, null);
        }
    };

    public PersonLabel() {
        this(defaultCallback);
    }

    public PersonLabel(PersonLabelClickEvent cb) {
        this.callback = cb;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PersonLabel.this.user != null && PersonLabel.this.callback != null && e.getButton() == 1 && PersonLabel.this.getX() >= 0 && PersonLabel.this.getY() >= 0) {
                    Dimension size = PersonLabel.this.getSize();
                    if (size.width > e.getX() && size.height > e.getY()) {
                        PersonLabel.this.callback.clicked(PersonLabel.this.user);
                    }
                }
            }
        });
    }

    public void setCallback(PersonLabelClickEvent cb) {
        this.callback = cb;
    }

    public void setUser(UserInfo user) {
        this.user = user;
        if (user == null) {
            this.setText(null);
        } else {
            this.setText(FormatHelper.userName(user));
        }
        if (user == null || user.eMail == null || user.eMail.isEmpty()) {
            this.setToolTipText(null);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setForeground(UIManager.getColor("Label.foreground"));
        } else {
            this.setToolTipText("Klicken, um eine Mail an diese Person zu senden");
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.setForeground(linkColor);
        }
    }

    public static interface PersonLabelClickEvent {
        public void clicked(UserInfo var1);
    }
}

