/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.Location;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.changemonitor.AbstractControlWrapper;
import org.openslx.dozmod.gui.changemonitor.DialogChangeMonitor;
import org.openslx.dozmod.gui.control.JCheckBoxTree;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.thrifthelper.Comparators;
import org.openslx.util.QuickTimer;

public class LocationSelector
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(LocationSelector.class);
    private final JRadioButton btnLimitToLocations;
    private final JRadioButton btnPrioritizeInLocations;
    private final ButtonGroup grpLocationExclusive;
    private boolean initDone = false;
    private List<Integer> preselection = null;
    private JCheckBoxTree locationTree = new JCheckBoxTree();
    private HashMap<Integer, DefaultMutableTreeNode> locationNodesMap = new HashMap();
    private AbstractControlWrapper<?> treeChangeHandler = null;

    public LocationSelector() {
        this.btnLimitToLocations = new JRadioButton("Veranstaltung ausschlie\u00dflich in den ausgew\u00e4hlten R\u00e4umen anzeigen");
        this.btnPrioritizeInLocations = new JRadioButton("Veranstaltung mit h\u00f6herer Priorit\u00e4t in den ausgew\u00e4hlten R\u00e4umen anzeigen");
        this.btnPrioritizeInLocations.setSelected(true);
        this.grpLocationExclusive = new ButtonGroup();
        this.grpLocationExclusive.add(this.btnLimitToLocations);
        this.grpLocationExclusive.add(this.btnPrioritizeInLocations);
        GridManager grid = new GridManager(this, 1);
        grid.add(new JScrollPane(this.locationTree)).fill(true, true).expand(true, true);
        grid.nextRow();
        grid.add(this.btnLimitToLocations);
        grid.nextRow();
        grid.add(this.btnPrioritizeInLocations);
        grid.nextRow();
        grid.add(Box.createVerticalGlue());
        grid.nextRow();
        grid.finish(false);
        this.init();
    }

    private void init() {
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                final List<Location> locsList = MetaDataCache.getLocations();
                if (locsList == null) {
                    return;
                }
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LocationSelector.this.fillLocationsList(locsList);
                        LocationSelector.this.initDone = true;
                        if (LocationSelector.this.preselection != null) {
                            LocationSelector.this.setSelectionInternal(LocationSelector.this.preselection);
                            LocationSelector.this.preselection = null;
                            if (LocationSelector.this.treeChangeHandler != null) {
                                LocationSelector.this.treeChangeHandler.reset();
                            }
                        }
                    }
                });
            }
        });
    }

    private void fillLocationsList(List<Location> locations) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(Session.getSatelliteAddress());
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode, true);
        for (Location loc : locations) {
            if (loc == null) continue;
            this.locationNodesMap.put(loc.getLocationId(), new DefaultMutableTreeNode(loc, true));
        }
        for (Integer id : this.locationNodesMap.keySet()) {
            int childrenCount;
            Location location = MetaDataCache.getLocationById(id);
            if (location == null) continue;
            DefaultMutableTreeNode parentNode = null;
            parentNode = location.getParentLocationId() == 0 ? rootNode : this.locationNodesMap.get(location.getParentLocationId());
            int insertionIndex = childrenCount = parentNode.getChildCount();
            if (childrenCount != 0) {
                Enumeration<TreeNode> enumeration = parentNode.children();
                while (enumeration.hasMoreElements()) {
                    Location childLocation;
                    DefaultMutableTreeNode currentChild = (DefaultMutableTreeNode)enumeration.nextElement();
                    if (currentChild == null || (childLocation = (Location)currentChild.getUserObject()) == null || Comparators.location.compare(location, childLocation) > 0) continue;
                    insertionIndex = parentNode.getIndex(currentChild);
                    break;
                }
            }
            treeModel.insertNodeInto(this.locationNodesMap.get(location.getLocationId()), parentNode, insertionIndex);
        }
        this.locationTree.setModel(treeModel);
        this.locationTree.updateUI();
        this.locationTree.repaint();
    }

    public void setOnlyInSelection(boolean limited) {
        this.btnLimitToLocations.setSelected(limited);
        this.btnPrioritizeInLocations.setSelected(!limited);
    }

    public boolean getOnlyInSelection() {
        return this.btnLimitToLocations.isSelected();
    }

    public void setSelectedLocationsAsIds(List<Integer> list) {
        if (list == null) {
            LOGGER.error("No list given!");
            return;
        }
        if (this.initDone) {
            this.setSelectionInternal(list);
        } else {
            if (this.treeChangeHandler != null) {
                this.treeChangeHandler.mute();
            }
            this.preselection = list;
        }
    }

    public List<Integer> getSelectedLocationsAsIds() {
        ArrayList<TreePath> tmp;
        TreePath[] paths = this.locationTree.getCheckedPaths();
        if (paths == null || paths.length == 0) {
            return new ArrayList<Integer>();
        }
        ArrayList<TreePath> leavesPathsList = new ArrayList<TreePath>();
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null || !node.isLeaf()) continue;
            leavesPathsList.add(path);
        }
        List<TreePath> currentList = leavesPathsList;
        while (!(tmp = currentList).equals(currentList = this.minify(currentList))) {
        }
        ArrayList<Integer> idList = new ArrayList<Integer>(currentList.size());
        for (TreePath path : currentList) {
            Object currentDataObject;
            DefaultMutableTreeNode currentNode;
            if (path == null || (currentNode = (DefaultMutableTreeNode)path.getLastPathComponent()) == null || !((currentDataObject = currentNode.getUserObject()) instanceof Location)) continue;
            Location currentLocation = (Location)currentDataObject;
            idList.add(currentLocation.getLocationId());
        }
        Collections.sort(idList);
        return idList;
    }

    private List<TreePath> minify(List<TreePath> leavesPathsList) {
        ArrayList<TreePath> resultList = new ArrayList<TreePath>();
        for (TreePath leaf : leavesPathsList) {
            DefaultMutableTreeNode leafNode = (DefaultMutableTreeNode)leaf.getLastPathComponent();
            if (leafNode.getParent() == null) continue;
            if (leafNode.getLevel() == 1) {
                resultList.add(LocationSelector.getPath(leafNode));
                continue;
            }
            Enumeration<? extends TreeNode> leafSiblings = leafNode.getParent().children();
            ArrayList<TreePath> selectedSiblings = new ArrayList<TreePath>();
            while (leafSiblings.hasMoreElements()) {
                DefaultMutableTreeNode leafSibling = (DefaultMutableTreeNode)leafSiblings.nextElement();
                if (!leavesPathsList.contains(LocationSelector.getPath(leafSibling))) continue;
                selectedSiblings.add(LocationSelector.getPath(leafSibling));
            }
            if (selectedSiblings.size() == leafNode.getParent().getChildCount()) {
                if (resultList.contains(LocationSelector.getPath(leafNode.getParent()))) continue;
                resultList.add(LocationSelector.getPath(leafNode.getParent()));
                continue;
            }
            for (TreePath sibling : selectedSiblings) {
                if (resultList.contains(sibling)) continue;
                resultList.add(sibling);
            }
        }
        return resultList;
    }

    public static TreePath getPath(TreeNode treeNode) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        if (treeNode != null) {
            nodes.add(treeNode);
            for (treeNode = treeNode.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
                nodes.add(0, treeNode);
            }
        }
        return nodes.isEmpty() ? null : new TreePath(nodes.toArray());
    }

    private void setSelectionInternal(List<Integer> list) {
        TreePath path;
        DefaultMutableTreeNode current;
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<TreePath> selectedPathsList = new ArrayList<TreePath>(Math.max(MetaDataCache.getLocations().size(), list.size()));
        for (Location location : MetaDataCache.getLocations()) {
            current = this.locationNodesMap.get(location.locationId);
            if (current == null) continue;
            path = new TreePath(current.getPath());
            selectedPathsList.add(path);
        }
        this.locationTree.setCheckedState(selectedPathsList, false);
        selectedPathsList.clear();
        for (Integer id : list) {
            current = this.locationNodesMap.get(id);
            if (current == null) continue;
            path = new TreePath(current.getPath());
            selectedPathsList.add(path);
        }
        this.locationTree.setCheckedState(selectedPathsList, true);
        this.locationTree.repaint();
    }

    public void addToChangeMonitor(DialogChangeMonitor changeMonitor) {
        this.treeChangeHandler = changeMonitor.add(this.locationTree);
        changeMonitor.add(this.grpLocationExclusive);
    }

    public void addCheckChangeEventListener(JCheckBoxTree.CheckChangeEventListener checkChangeEventListener) {
        this.locationTree.addCheckChangeEventListener(checkChangeEventListener);
    }
}

