/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.configurator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.NetShare;
import org.openslx.bwlp.thrift.iface.NetShareAuth;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.changemonitor.DialogChangeMonitor;
import org.openslx.dozmod.gui.configurator.NetshareConfiguratorLayout;
import org.openslx.dozmod.gui.control.table.CheckListTable;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.thrift.cache.MetaDataCache;

public class NetshareConfigurator
extends NetshareConfiguratorLayout {
    private static final long serialVersionUID = -3336605759245603655L;
    private static final Logger LOGGER = Logger.getLogger(NetshareConfigurator.class);
    public static final Character EMPTY_MARKER = Character.valueOf('-');
    public static final String PRINTER_MARKER = "PRINTER";
    private Character[] mountPoints = new Character[]{EMPTY_MARKER, Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')};

    public NetshareConfigurator() {
        this.tblNetshare.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                NetShare item = (NetShare)NetshareConfigurator.this.tblNetshare.getSelectedItem2();
                boolean editable = item == null || item.shareId == 0;
                NetshareConfigurator.this.btnDel.setEnabled(editable);
                NetshareConfigurator.this.btnAdd.setEnabled(editable);
                NetshareConfigurator.this.tfSharePath.setEnabled(editable);
                NetshareConfigurator.this.tfShareName.setEnabled(editable);
                NetshareConfigurator.this.tfUsername.setEnabled(editable);
                NetshareConfigurator.this.tfPassword.setEnabled(editable);
                NetshareConfigurator.this.cboNetshareAuth.setEnabled(editable);
                NetshareConfigurator.this.cboNetshareMountPoint.setEnabled(editable);
                NetshareConfigurator.this.chkIsPrinter.setEnabled(editable);
                NetshareConfigurator.this.chkShowPass.setEnabled(editable);
                if (item == null) {
                    NetshareConfigurator.this.clearInputFields();
                    return;
                }
                NetshareConfigurator.this.tfSharePath.setText(item.path);
                if (item.displayname != null) {
                    NetshareConfigurator.this.tfShareName.setText(String.valueOf(EMPTY_MARKER).equals(item.displayname) ? "" : item.displayname);
                }
                NetshareConfigurator.this.tfUsername.setText(item.username);
                NetshareConfigurator.this.tfPassword.setText(item.password);
                NetshareConfigurator.this.cboNetshareAuth.setSelectedItem(item.auth);
                if (item.mountpoint != null) {
                    boolean isPrinter = item.mountpoint.equals(NetshareConfigurator.PRINTER_MARKER);
                    NetshareConfigurator.this.chkIsPrinter.setSelected(isPrinter);
                    NetshareConfigurator.this.cboNetshareMountPoint.setSelectedItem(isPrinter ? null : (item.mountpoint.isEmpty() ? EMPTY_MARKER : Character.valueOf(item.mountpoint.charAt(0))));
                    NetshareConfigurator.this.cboNetshareMountPoint.setEnabled(editable && !isPrinter);
                }
                if (editable) {
                    NetshareConfigurator.this.btnAdd.setText("\u00c4ndern");
                }
            }
        });
        this.cboNetshareMountPoint.setModel(new DefaultComboBoxModel<Character>(this.mountPoints));
        this.cboNetshareMountPoint.setSelectedItem(null);
        this.chkIsPrinter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NetshareConfigurator.this.cboNetshareMountPoint.setEnabled(e.getStateChange() != 1);
            }
        });
        this.chkIsPrinter.setSelected(false);
        this.cboNetshareAuth.setModel(new DefaultComboBoxModel<NetShareAuth>(NetShareAuth.values()));
        this.cboNetshareAuth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetShareAuth selectedAuth = (NetShareAuth)NetshareConfigurator.this.cboNetshareAuth.getItemAt(NetshareConfigurator.this.cboNetshareAuth.getSelectedIndex());
                boolean activate = selectedAuth != null && selectedAuth == NetShareAuth.OTHER_USER;
                NetshareConfigurator.this.tfUsername.setEnabled(activate);
                NetshareConfigurator.this.tfPassword.setEnabled(activate);
                NetshareConfigurator.this.chkShowPass.setEnabled(activate);
            }
        });
        this.cboNetshareAuth.setSelectedItem(null);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetShare input = new NetShare();
                input.path = NetshareConfigurator.this.tfSharePath.getText();
                if (input.path == null || input.path.isEmpty()) {
                    NetshareConfigurator.this.lblError.setText("Kein Pfad angegeben!");
                    return;
                }
                String inputShareName = NetshareConfigurator.this.tfShareName.getText();
                if (inputShareName.isEmpty()) {
                    inputShareName = String.valueOf(EMPTY_MARKER);
                }
                input.displayname = inputShareName;
                NetShareAuth inputNetShareAuth = (NetShareAuth)NetshareConfigurator.this.cboNetshareAuth.getItemAt(NetshareConfigurator.this.cboNetshareAuth.getSelectedIndex());
                if (inputNetShareAuth == null) {
                    NetshareConfigurator.this.lblError.setText("Kein Authentifizierungstyp angegeben!");
                    return;
                }
                input.auth = inputNetShareAuth;
                switch (inputNetShareAuth) {
                    case LOGIN_USER: {
                        break;
                    }
                    case OTHER_USER: {
                        input.username = NetshareConfigurator.this.tfUsername.getText();
                        input.password = new String(NetshareConfigurator.this.tfPassword.getPassword());
                        if (!input.username.isEmpty()) break;
                        NetshareConfigurator.this.lblError.setText("Kein Nutzername angegeben!");
                        return;
                    }
                    default: {
                        input = null;
                    }
                }
                if (input == null) {
                    NetshareConfigurator.this.lblError.setText("Fehlerhafte Eingabe");
                    LOGGER.debug("Bad input, aborting.");
                    return;
                }
                Character inputMountPoint = (Character)NetshareConfigurator.this.cboNetshareMountPoint.getItemAt(NetshareConfigurator.this.cboNetshareMountPoint.getSelectedIndex());
                if (!NetshareConfigurator.this.chkIsPrinter.isSelected()) {
                    if (inputMountPoint == null) {
                        NetshareConfigurator.this.lblError.setText("Kein Laufwerk angegeben!");
                        return;
                    }
                    input.mountpoint = String.valueOf(inputMountPoint);
                } else {
                    input.mountpoint = NetshareConfigurator.PRINTER_MARKER;
                }
                if (input.password != null && !input.password.isEmpty() && !Gui.showMessageBox("Das eingebene Passwort wird im Klartext gespeichert und ist in der VM f\u00fcr jeden Nutzer sichtbar.\nVerwenden Sie auf keinen Fall sicherheitskritische Passw\u00f6rter!\n\nM\u00f6chten Sie diesen Netzlaufwerk trotzdem hinzuf\u00fcgen?", MessageType.QUESTION_YESNO, LOGGER, null)) {
                    return;
                }
                CheckListTable.Wrapper<NetShare> newEntry = new CheckListTable.Wrapper<NetShare>(input, false);
                CheckListTable.Wrapper oldEntry = (CheckListTable.Wrapper)NetshareConfigurator.this.tblNetshare.getSelectedItem();
                ArrayList oldList = new ArrayList(NetshareConfigurator.this.tblNetshare.getData());
                if (oldEntry != null && oldList.contains(oldEntry) && !oldList.remove(oldEntry)) {
                    NetshareConfigurator.this.lblError.setText("\u00c4nderung fehlgeschlagen!");
                    LOGGER.error("Failed to remove selected share for replacement: " + oldEntry);
                    return;
                }
                if (oldList.contains(newEntry)) {
                    NetshareConfigurator.this.lblError.setText("Existiert bereits!");
                    LOGGER.error("Network share already in the list, aborting.");
                    return;
                }
                NetshareConfigurator.this.lblError.setText(null);
                oldList.add(newEntry);
                NetshareConfigurator.this.tblNetshare.setData(oldList, false);
                NetshareConfigurator.this.clearInputFields();
            }
        });
        this.btnDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckListTable.Wrapper selection = (CheckListTable.Wrapper)NetshareConfigurator.this.tblNetshare.getSelectedItem();
                if (selection == null) {
                    return;
                }
                ArrayList oldList = new ArrayList(NetshareConfigurator.this.tblNetshare.getData());
                try {
                    if (!oldList.remove(selection)) {
                        LOGGER.error("Could not remove non-existant network share '" + selection.toString() + "' from the table data: " + ((Object)oldList).toString());
                        return;
                    }
                    NetshareConfigurator.this.tblNetshare.setData(oldList, true);
                }
                catch (Exception ex) {
                    LOGGER.debug("Failed to remove " + selection.toString() + " from the table data.", ex);
                    return;
                }
            }
        });
        this.chkShowPass.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    NetshareConfigurator.this.tfPassword.setEchoChar('*');
                } else {
                    NetshareConfigurator.this.tfPassword.setEchoChar('\u0000');
                }
            }
        });
        this.clearInputFields();
    }

    private void clearInputFields() {
        this.btnDel.setEnabled(false);
        this.tfSharePath.setText(null);
        this.tfShareName.setText(null);
        this.tfUsername.setText(null);
        this.tfPassword.setText(null);
        this.cboNetshareAuth.setSelectedItem(null);
        this.cboNetshareMountPoint.setSelectedItem(null);
        this.chkIsPrinter.setSelected(false);
        this.chkShowPass.setSelected(false);
        this.btnAdd.setText("Hinzuf\u00fcgen");
    }

    public List<NetShare> getState() {
        List list = this.tblNetshare.getData();
        if (list == null) {
            return new ArrayList<NetShare>(0);
        }
        ArrayList<NetShare> ret = new ArrayList<NetShare>();
        for (CheckListTable.Wrapper item : list) {
            if (!item.isChecked() && ((NetShare)item.item).shareId != 0) continue;
            ret.add((NetShare)item.item);
        }
        return ret;
    }

    public boolean setState(List<NetShare> data, List<Integer> predefSelected) {
        if (data == null) {
            return false;
        }
        ArrayList<NetShare> shareList = new ArrayList<NetShare>(data);
        List<NetShare> predef = MetaDataCache.getPredefinedNetshares();
        HashSet<NetShare> checked = new HashSet<NetShare>();
        for (NetShare share : predef) {
            shareList.add(share);
            if (predefSelected == null || !predefSelected.contains(share.shareId)) continue;
            checked.add(share);
        }
        this.tblNetshare.setData(shareList, checked, false);
        return true;
    }

    public void addTableModelListener(TableModelListener listener) {
        ((AbstractTableModel)this.tblNetshare.getModel()).addTableModelListener(listener);
    }

    public void addToChangeMonitor(DialogChangeMonitor changeMonitor) {
        changeMonitor.add(this.tblNetshare);
    }
}

