/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.changemonitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openslx.dozmod.gui.changemonitor.DialogChangeMonitor;

public abstract class AbstractControlWrapper<T> {
    private final DialogChangeMonitor dcm;
    protected boolean wasEverChanged;
    protected boolean isCurrentlyChanged;
    private T originalContent;
    private List<DialogChangeMonitor.ValidationConstraint<T>> constraints;
    private final Comparator<T> cmp;
    protected String currentError = null;
    private boolean muted = false;

    protected AbstractControlWrapper(DialogChangeMonitor dcm, Comparator<T> comp) {
        this.dcm = dcm;
        this.cmp = comp;
    }

    public boolean hasChangedSinceInit() {
        return this.wasEverChanged;
    }

    public boolean isCurrentlyChanged() {
        return this.isCurrentlyChanged;
    }

    public String currentConstraintError() {
        return this.currentError;
    }

    public AbstractControlWrapper<T> addConstraint(DialogChangeMonitor.ValidationConstraint<T> constraint) {
        if (this.constraints == null) {
            this.constraints = new ArrayList<DialogChangeMonitor.ValidationConstraint<T>>();
        }
        this.constraints.add(constraint);
        return this;
    }

    public void reset() {
        boolean wasChanged = this.wasEverChanged;
        this.resetChangeState();
        if (wasChanged) {
            this.dcm.contentChanged(this);
        }
    }

    protected final void resetChangeState() {
        this.muted = false;
        this.wasEverChanged = false;
        this.isCurrentlyChanged = false;
        this.originalContent = this.getCurrentValue();
        this.checkValid(this.originalContent);
    }

    protected final void contentChanged() {
        T text = this.getCurrentValue();
        this.checkChanged(text);
        this.checkValid(text);
    }

    public void mute() {
        this.muted = true;
    }

    abstract T getCurrentValue();

    protected void checkChanged(T newContent) {
        boolean changed;
        if (this.muted) {
            return;
        }
        if (newContent == this.originalContent) {
            changed = false;
        } else if (newContent == null || this.originalContent == null) {
            changed = true;
        } else if (newContent instanceof Collection && ((Collection)newContent).size() != ((Collection)this.originalContent).size()) {
            changed = true;
        } else if (newContent instanceof Map && ((Map)newContent).size() != ((Map)this.originalContent).size()) {
            changed = true;
        } else if (this.cmp == null) {
            changed = !this.originalContent.equals(newContent);
        } else {
            boolean bl = changed = this.cmp.compare(this.originalContent, newContent) != 0;
        }
        if (this.isCurrentlyChanged != changed) {
            this.isCurrentlyChanged = changed;
            this.dcm.contentChanged(this);
        }
    }

    protected void checkValid(T text) {
        DialogChangeMonitor.ValidationConstraint<T> i;
        if (this.muted || this.constraints == null || this.constraints.isEmpty()) {
            return;
        }
        String error = null;
        Iterator<DialogChangeMonitor.ValidationConstraint<T>> iterator = this.constraints.iterator();
        while (iterator.hasNext() && (error = (i = iterator.next()).checkStateValid(text)) == null) {
        }
        if (error == null && this.currentError != null || error != null && this.currentError == null || error != null && !error.equals(this.currentError)) {
            this.currentError = error;
            this.dcm.validityChanged(this);
        }
    }
}

