/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui;

import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.SatelliteStatus;
import org.openslx.bwlp.thrift.iface.TransferState;
import org.openslx.dozmod.App;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.filetransfer.DownloadTask;
import org.openslx.dozmod.filetransfer.PassiveTransfer;
import org.openslx.dozmod.filetransfer.TransferEvent;
import org.openslx.dozmod.filetransfer.TransferEventListener;
import org.openslx.dozmod.filetransfer.UploadTask;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.activity.ActivityPanel;
import org.openslx.dozmod.gui.activity.DownloadPanel;
import org.openslx.dozmod.gui.activity.PassiveUploadPanel;
import org.openslx.dozmod.gui.activity.UpdatePanel;
import org.openslx.dozmod.gui.activity.UploadPanel;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.helper.CompositePage;
import org.openslx.dozmod.gui.helper.DebugWindow;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.UiFeedback;
import org.openslx.dozmod.gui.window.CheckUpdateWindow;
import org.openslx.dozmod.gui.window.ConfigWindow;
import org.openslx.dozmod.gui.window.DisclaimerWindow;
import org.openslx.dozmod.gui.window.ImageListWindow;
import org.openslx.dozmod.gui.window.LectureListWindow;
import org.openslx.dozmod.gui.window.LoginWindow;
import org.openslx.dozmod.gui.window.MainMenuWindow;
import org.openslx.dozmod.gui.window.PrivacyNoticeWindow;
import org.openslx.dozmod.gui.window.VirtualizerNoticeWindow;
import org.openslx.dozmod.state.UploadWizardState;
import org.openslx.dozmod.thrift.GuiErrorCallback;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.util.ClientVersion;
import org.openslx.dozmod.util.DesktopEnvironment;
import org.openslx.dozmod.util.FormatHelper;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

public abstract class MainWindow {
    private static final Logger LOGGER = Logger.getLogger(MainWindow.class);
    private static final JFrame mainWindow;
    private static final JPanel mainContainer;
    private static final JPanel activityPanel;
    private static CompositePage currentPage;
    private static boolean isQuitQuestionOpen;
    private static final Map<Class<? extends CompositePage>, CompositePage> pages;
    private static final List<ActivityPanel> activities;
    private static boolean initOnce;

    public static <T extends CompositePage> T showPage(Class<T> clazz) {
        T page = MainWindow.getPage(clazz);
        if (page == null) {
            throw new RuntimeException("Tried to show unknown page " + clazz.getSimpleName());
        }
        if (currentPage != null) {
            if (!currentPage.requestHide()) {
                return null;
            }
            currentPage.setVisible(false);
        }
        currentPage = page;
        currentPage.requestShow();
        currentPage.setVisible(true);
        mainWindow.validate();
        return page;
    }

    public static <T extends CompositePage> T getPage(Class<T> clazz) {
        CompositePage page = pages.get(clazz);
        if (page == null) {
            return null;
        }
        return (T)page;
    }

    public static void centerShell(Window shell) {
        Gui.centerShellOverShell(mainWindow, shell);
    }

    public static void open() {
        mainWindow.setDefaultCloseOperation(0);
        mainWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.askApplicationQuit();
            }
        });
        ThriftManager.setMasterErrorCallback(new GuiErrorCallback(mainWindow, "dem " + Branding.getServiceName() + "-Zentralserver"));
        ThriftManager.setSatelliteErrorCallback(new GuiErrorCallback(mainWindow, "dem Satellitenserver"));
        Config.setErrorCallback(new Config.ErrorCallback(){

            @Override
            public void writeError(final Throwable t) {
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Gui.showMessageBox(mainWindow, "Konnte Programmeinstellungen nicht speichern", MessageType.WARNING, LOGGER, t);
                    }
                });
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent event) {
                Window window;
                int type = event.getID();
                char code = event.getKeyChar();
                if (code == '\u0011') {
                    if (type == 402 && !isQuitQuestionOpen) {
                        isQuitQuestionOpen = true;
                        MainWindow.askApplicationQuit();
                        event.consume();
                    }
                } else if ((code == '\u001b' || code == '\u0017') && type == 401 && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) instanceof UiFeedback) {
                    ((UiFeedback)((Object)window)).escapePressed();
                    event.consume();
                }
                return event.isConsumed();
            }
        });
        mainContainer.setLayout(new BoxLayout(mainContainer, 3));
        mainWindow.setMinimumSize(Gui.getScaledDimension(1050, 670));
        MainWindow.registerPage(new MainMenuWindow());
        MainWindow.registerPage(new ImageListWindow());
        MainWindow.registerPage(new LectureListWindow());
        MainWindow.registerPage(new PleaseWait());
        if (System.getProperty("log") != null) {
            DebugWindow win = new DebugWindow();
            win.setMinimumSize(Gui.getScaledDimension(0, 250));
            win.setPreferredSize(win.getMinimumSize());
            mainWindow.getContentPane().add((Component)win, "First");
        }
        activityPanel.setLayout(new BoxLayout(activityPanel, 3));
        activityPanel.setVisible(false);
        activityPanel.add(new JSeparator());
        mainWindow.getContentPane().add((Component)activityPanel, "Last");
        mainWindow.getContentPane().add((Component)mainContainer, "Center");
        mainWindow.setLocationRelativeTo(null);
        mainWindow.setVisible(true);
        if (Config.getSavedSession() == null) {
            LoginWindow.open(mainWindow);
            MainWindow.initWindow();
        } else {
            if (!App.isInitDone()) {
                MainWindow.showPage(PleaseWait.class);
            }
            QuickTimer.scheduleOnce(new QuickTimer.Task(){

                @Override
                public void fire() {
                    App.waitForInit();
                    if (ThriftActions.initSession(null, false, SwingUtilities.getWindowAncestor(mainWindow))) {
                        MainWindow.initWindow();
                    } else {
                        Gui.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                LoginWindow.open(mainWindow);
                                MainWindow.initWindow();
                            }
                        });
                    }
                }
            });
        }
    }

    private static void initWindow() {
        if (initOnce || !App.isInitDone()) {
            return;
        }
        initOnce = true;
        if (Session.getSatelliteToken() == null) {
            System.exit(42);
        }
        if (!ClientVersion.isNewest()) {
            MainWindow.addPanel(new UpdatePanel(ClientVersion.getRemoteRevision()));
        }
        MainWindow.showPage(MainMenuWindow.class);
        MainWindow.createMenu();
        mainWindow.setTitle(Branding.getApplicationName() + " - " + Session.getFirstName() + " " + Session.getLastName() + " [" + Session.getSatelliteAddress() + "]");
        if (DisclaimerWindow.shouldBeShown()) {
            DisclaimerWindow.open(mainWindow);
        }
        if (PrivacyNoticeWindow.shouldBeShown()) {
            PrivacyNoticeWindow.open(mainWindow);
        }
    }

    protected static void askApplicationQuit() {
        boolean open = false;
        for (ActivityPanel activity : activities) {
            if (!activity.wantConfirmQuit()) continue;
            open = true;
            break;
        }
        if (!open) {
            Window[] windows;
            for (Window window : windows = Window.getWindows()) {
                if (!window.isVisible() || !(window instanceof UiFeedback) || !((UiFeedback)((Object)window)).wantConfirmQuit()) continue;
                open = true;
                break;
            }
        }
        if (!open || Gui.showMessageBox(mainWindow, "M\u00f6chten Sie das Programm wirklich beenden?", MessageType.QUESTION_YESNO, null, null)) {
            Gui.exit(0);
        }
        isQuitQuestionOpen = false;
    }

    private static synchronized void registerPage(CompositePage window) {
        Class<?> clazz = window.getClass();
        if (pages.containsKey(clazz)) {
            throw new IllegalArgumentException("Page " + clazz.getSimpleName() + " already registered!");
        }
        pages.put(clazz, window);
        mainContainer.add(window);
        window.setVisible(false);
    }

    private static void addPanel(ActivityPanel panel) {
        activities.add(panel);
        activityPanel.add(panel);
        activityPanel.setVisible(true);
        mainWindow.validate();
    }

    public static void addUpload(UploadWizardState state) {
        MainWindow.addPanel(new UploadPanel(state));
        final UploadTask task = state.upload.getUploadTask();
        task.addListener(new TransferEventListener(){

            @Override
            public void update(TransferEvent event) {
                if (event.state == TransferState.FINISHED) {
                    ImageListWindow page = MainWindow.getPage(ImageListWindow.class);
                    if (page != null) {
                        page.refresh(true);
                    }
                    task.removeListener(this);
                }
            }
        });
    }

    public static void addPassiveTransfer(String transferToken, String name, boolean queryMaster) {
        final PassiveTransfer transfer = new PassiveTransfer(transferToken, queryMaster);
        MainWindow.addPanel(new PassiveUploadPanel(transfer, name));
        transfer.addListener(new TransferEventListener(){

            @Override
            public void update(TransferEvent event) {
                if (event.state == TransferState.FINISHED) {
                    ImageListWindow page = MainWindow.getPage(ImageListWindow.class);
                    if (page != null) {
                        page.refresh(true);
                    }
                    transfer.removeListener(this);
                }
            }
        });
    }

    public static void addDownload(String imageName, String diskFile, DownloadTask dlTask) {
        MainWindow.addPanel(new DownloadPanel(imageName, diskFile, dlTask));
    }

    public static void removeActivity(ActivityPanel panel) {
        activities.remove(panel);
        activityPanel.remove(panel);
        if (activities.isEmpty()) {
            activityPanel.setVisible(false);
        }
        mainWindow.validate();
    }

    private static void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        mainWindow.setJMenuBar(menuBar);
        JMenu cascadeSessionMenu = new JMenu("Sitzung");
        menuBar.add(cascadeSessionMenu);
        JMenuItem configItem = new JMenuItem("Einstellungen");
        cascadeSessionMenu.add(configItem);
        JMenuItem logDirItem = new JMenuItem("Logverzeichnis \u00f6ffnen");
        cascadeSessionMenu.add(logDirItem);
        cascadeSessionMenu.addSeparator();
        JMenuItem logoutItem = new JMenuItem("Abmelden und beenden");
        cascadeSessionMenu.add(logoutItem);
        JMenuItem exitItem = new JMenuItem("Beenden");
        cascadeSessionMenu.add(exitItem);
        JMenu cascadeViewMenu = new JMenu("Ansicht");
        menuBar.add(cascadeViewMenu);
        JMenuItem homeItem = new JMenuItem("Startseite");
        cascadeViewMenu.add(homeItem);
        JMenuItem imagesItem = new JMenuItem("Virtuelle Maschinen");
        cascadeViewMenu.add(imagesItem);
        if (!Session.canListImages()) {
            imagesItem.setEnabled(false);
        }
        JMenuItem lecturesItem = new JMenuItem("Veranstaltungen");
        cascadeViewMenu.add(lecturesItem);
        JMenu cascadeAboutMenu = new JMenu("\u00dcber");
        menuBar.add(cascadeAboutMenu);
        JMenuItem disclaimerItem = new JMenuItem("Nutzungsvereinbarung");
        JMenuItem privacyNoticeItem = new JMenuItem("Datenschutzerkl\u00e4rung");
        JMenuItem virtualizerNoticeItem = new JMenuItem("Virtualisierer");
        JMenuItem wikiItem = new JMenuItem(Branding.getServiceFAQWebsite());
        JMenuItem updateCheckItem = new JMenuItem("Software-Aktualisierung");
        cascadeAboutMenu.add(disclaimerItem);
        cascadeAboutMenu.add(privacyNoticeItem);
        cascadeAboutMenu.add(virtualizerNoticeItem);
        cascadeAboutMenu.addSeparator();
        cascadeAboutMenu.add(wikiItem);
        cascadeAboutMenu.add(updateCheckItem);
        menuBar.add(Box.createHorizontalGlue());
        final QLabel memStats = new QLabel();
        menuBar.add(memStats);
        homeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.showPage(MainMenuWindow.class);
            }
        });
        imagesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.showPage(ImageListWindow.class);
            }
        });
        lecturesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.showPage(LectureListWindow.class);
            }
        });
        configItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigWindow.open(mainWindow);
            }
        });
        logDirItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopEnvironment.openLocal(new File(Config.getPath()));
            }
        });
        logoutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.saveCurrentSession("", "", "");
                MainWindow.askApplicationQuit();
            }
        });
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.askApplicationQuit();
            }
        });
        disclaimerItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisclaimerWindow.open(mainWindow);
            }
        });
        privacyNoticeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrivacyNoticeWindow.open(mainWindow);
            }
        });
        virtualizerNoticeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualizerNoticeWindow.open(mainWindow);
            }
        });
        wikiItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DesktopEnvironment.openWebpage(DesktopEnvironment.Link.FAQ);
            }
        });
        updateCheckItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckUpdateWindow.open(mainWindow);
            }
        });
        QuickTimer.scheduleAtFixedDelay(new QuickTimer.Task(){
            private int failures = 0;
            private int ignoreCount = 0;
            private String remoteString = "";
            private boolean timeDiffChecked = false;

            @Override
            public void fire() {
                Runtime rt = Runtime.getRuntime();
                long maxMemory = rt.maxMemory();
                long totalMemory = rt.totalMemory();
                long usedMemory = totalMemory - rt.freeMemory();
                String txt = "[JVM: " + FormatHelper.bytes(usedMemory, false) + "/" + FormatHelper.bytes(totalMemory, false);
                if (maxMemory != Long.MAX_VALUE) {
                    txt = txt + ", Limit: " + FormatHelper.bytes(maxMemory, false);
                }
                txt = txt + "]";
                if (this.ignoreCount > 0) {
                    --this.ignoreCount;
                } else if (Session.getUserId() != null) {
                    try {
                        long inactiveMins;
                        SatelliteStatus status = ThriftManager.getSatClient().getStatus();
                        this.failures = 0;
                        this.remoteString = " [Store: " + FormatHelper.bytes(status.availableStorageBytes, false) + "]";
                        if (!this.timeDiffChecked) {
                            long now = System.currentTimeMillis() / 1000L;
                            long diffSecs = Math.abs(now - status.serverTime);
                            LOGGER.debug("Clock diff client<->server: " + diffSecs + "s");
                            this.timeDiffChecked = true;
                            if (diffSecs > TimeUnit.MINUTES.toMillis(10L)) {
                                Gui.asyncMessageBox("ACHTUNG: Die Uhrzeit Ihres Computers weicht von der Uhrzeit auf dem Satellitenserver ab.\nBitte stellen Sie sicher, dass die Uhr Ihres Computers richtig gestellt ist.\nFalls Ihre Sytemzeit korrekt gesetzt ist, ist m\u00f6glicherweise die Uhrzeit auf\ndem Satellitenserver nicht korrekt eingestellt.\nIn diesem Fall kann es - je nach Abweichung - zu unerwarteten Problemen mit den\nStart- und Endzeiten von Veranstaltungen kommen. Kontaktieren Sie in diesem\nFall den zust\u00e4ndigen Administrator, damit die Uhrzeit auf dem Satellitenserver\nkorrigiert werden kann.\n\nIhr Computer: " + FormatHelper.longDate(now) + "\nSatellitenserver: " + FormatHelper.longDate(status.serverTime), MessageType.WARNING, LOGGER, null);
                            }
                        }
                        if ((inactiveMins = (System.currentTimeMillis() - Gui.getLastUserActivityMillis()) / 60000L) > 10L && UploadTask.getNumberOfUploads() == 0) {
                            this.ignoreCount = 30;
                        }
                    }
                    catch (TException e) {
                        ++this.failures;
                        this.ignoreCount = Math.min(10, this.failures / 3);
                        this.remoteString = " [Store: ???]";
                    }
                }
                final String labelText = txt + this.remoteString;
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        memStats.setText(labelText);
                    }
                });
            }
        }, 10L, 2001L);
    }

    static {
        isQuitQuestionOpen = false;
        pages = new ConcurrentHashMap<Class<? extends CompositePage>, CompositePage>();
        activities = new ArrayList<ActivityPanel>();
        mainWindow = Gui.syncExec(new Gui.GuiCallable<JFrame>(){

            @Override
            public JFrame run() {
                return new JFrame(Branding.getApplicationName());
            }
        });
        mainContainer = Gui.syncExec(new Gui.GuiCallable<JPanel>(){

            @Override
            public JPanel run() {
                return new JPanel();
            }
        });
        activityPanel = Gui.syncExec(new Gui.GuiCallable<JPanel>(){

            @Override
            public JPanel run() {
                return new JPanel();
            }
        });
        initOnce = false;
    }

    private static class PleaseWait
    extends CompositePage {
        public PleaseWait() {
            GridManager grid = new GridManager(this, 3);
            grid.add(Box.createHorizontalGlue()).expand(true, true);
            grid.add(new JLabel("Bitte warten, suche Proxy-Konfiguration...")).expand(false, true).fill(true, true);
            grid.add(Box.createHorizontalGlue()).expand(true, true);
            grid.finish(false);
        }

        @Override
        public boolean requestHide() {
            return true;
        }

        @Override
        public void requestShow() {
        }
    }
}

