/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import org.apache.log4j.Logger;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.util.DesktopEnvironment;
import org.openslx.dozmod.util.ResourceLoader;
import org.openslx.util.QuickTimer;

public class Gui {
    private static final Logger LOGGER = Logger.getLogger(Gui.class);
    private static long lastUserActivity = System.currentTimeMillis();

    private static Rectangle clientArea(GraphicsDevice gd) {
        Insets inset = Toolkit.getDefaultToolkit().getScreenInsets(gd.getDefaultConfiguration());
        Rectangle bounds = gd.getDefaultConfiguration().getBounds();
        bounds.x += inset.left;
        bounds.y += inset.top;
        bounds.width -= inset.top + inset.bottom;
        bounds.height -= inset.left + inset.right;
        return bounds;
    }

    public static void centerShell(Window shell) {
        GraphicsDevice activeMonitor = Gui.getMonitorFromRectangle(shell.getBounds(), true);
        Rectangle bounds = Gui.clientArea(activeMonitor);
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(x, y);
    }

    public static void centerShellOverShell(Window parent, Window shellToCenter) {
        Rectangle bounds = parent.getBounds();
        Rectangle rect = shellToCenter.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        if (x < bounds.x) {
            x = bounds.x;
        }
        if (y < bounds.y) {
            y = bounds.y;
        }
        shellToCenter.setLocation(x, y);
    }

    public static void limitShellSize(JFrame window) {
        GraphicsDevice activeMonitor = Gui.getMonitorFromRectangle(window.getBounds(), true);
        Rectangle bounds = Gui.clientArea(activeMonitor);
        Rectangle rect = window.getBounds();
        boolean changed = false;
        if (rect.width + 20 > bounds.width) {
            rect.width = bounds.width - 20;
            changed = true;
        }
        if (rect.height + 20 > bounds.height) {
            rect.height = bounds.height - 20;
            changed = true;
        }
        if (changed) {
            window.setSize(rect.width, rect.height);
            rect = window.getBounds();
        }
        changed = false;
        if (rect.x + rect.width >= bounds.x + bounds.width) {
            rect.x = 5;
            changed = true;
        }
        if (rect.y + rect.height >= bounds.y + bounds.height) {
            rect.y = 5;
            changed = true;
        }
        if (changed) {
            window.setLocation(rect.x, rect.y);
        }
    }

    public static Dimension getScaledDimension(int width, int height) {
        int scale = Config.getFontScaling();
        return new Dimension(width * scale / 100, height * scale / 100);
    }

    public static Icon getScaledIconResource(String path, String description, int maxHeight, Component context) {
        int height = maxHeight * Config.getFontScaling() / 100;
        return ResourceLoader.getIcon(path, description, height, context);
    }

    private static GraphicsDevice getMonitorFromPoint(GraphicsDevice[] screens, Point point, boolean defaultToPrimary) {
        LOGGER.debug("Finding monitor for point " + point.toString());
        for (GraphicsDevice dev : screens) {
            Rectangle bounds = dev.getDefaultConfiguration().getBounds();
            LOGGER.debug("Checking monitor " + bounds.toString());
            if (!bounds.contains(point)) continue;
            return dev;
        }
        if (defaultToPrimary) {
            LOGGER.debug("Defaulting to primary...");
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
        return null;
    }

    public static GraphicsDevice getMonitorFromRectangle(Rectangle rect, boolean defaultToPrimary) {
        GraphicsDevice[] screens = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Rectangle bounds = new Rectangle();
        for (GraphicsDevice dev : screens) {
            bounds = bounds.union(dev.getDefaultConfiguration().getBounds());
        }
        LOGGER.debug("Display bounds are " + bounds.toString() + ", rect is " + rect.toString());
        if (rect.x + rect.width >= bounds.x + bounds.width) {
            rect.width -= rect.x + rect.width - (bounds.x + bounds.width);
            if (rect.width < 1) {
                rect.width = 1;
            }
        }
        if (rect.y + rect.height >= bounds.y + bounds.height) {
            rect.height -= rect.y + rect.height - (bounds.y + bounds.height);
            if (rect.height < 1) {
                rect.height = 1;
            }
        }
        if (rect.x < bounds.x) {
            rect.width -= bounds.x - rect.x;
            rect.x = bounds.x;
        }
        if (rect.y < bounds.y) {
            rect.height -= bounds.y - rect.y;
            rect.y = bounds.y;
        }
        LOGGER.debug("After correction: " + rect.toString());
        return Gui.getMonitorFromPoint(screens, new Point(rect.x + rect.width / 2, rect.y + rect.height / 2), defaultToPrimary);
    }

    public static <T> T syncExec(final GuiCallable<T> task) {
        final AtomicReference instance = new AtomicReference();
        final AtomicReference thrown = new AtomicReference();
        if (SwingUtilities.isEventDispatchThread()) {
            return task.run();
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        instance.set(task.run());
                    }
                    catch (Throwable e) {
                        thrown.set(e);
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.warn("syncExec() failed", e);
            return null;
        }
        if (thrown.get() != null) {
            throw new RuntimeException("task passed to syncExec() failed", (Throwable)thrown.get());
        }
        return (T)instance.get();
    }

    public static void asyncExec(Runnable task) {
        SwingUtilities.invokeLater(task);
    }

    public static void exit(int code) {
        Window[] ownerlessWindows;
        QuickTimer.cancel();
        for (Window w : ownerlessWindows = Frame.getOwnerlessWindows()) {
            w.dispose();
        }
        System.exit(code);
    }

    public static boolean showMessageBox(Component parent, String message, MessageType messageType, Logger logger, Throwable exception) {
        Window ancestor;
        if (logger != null) {
            logger.log(messageType.logPriority, message, exception);
        }
        if (parent == null) {
            parent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        } else if (!(parent instanceof Window) && (ancestor = SwingUtilities.getWindowAncestor(parent)) != null) {
            parent = ancestor;
        }
        if (exception != null) {
            message = message + "\n\n" + exception.getClass().getSimpleName() + "\n" + exception.getMessage() + "\n (F\u00fcr Stack-Trace siehe Logdatei)";
        }
        if (message.startsWith("<html>")) {
            JEditorPane ep = new JEditorPane("text/html", message);
            ep.setEditable(false);
            ep.setOpaque(false);
            Font font = UIManager.getFont("Label.font");
            String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
            ((HTMLDocument)ep.getDocument()).getStyleSheet().addRule(bodyRule);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        try {
                            DesktopEnvironment.openWebpageUri(e.getURL().toURI());
                        }
                        catch (URISyntaxException ex) {
                            LOGGER.error("Couldn't parse hyperlink", ex);
                        }
                    }
                }
            });
            JOptionPane.showMessageDialog(parent, ep, messageType.title, messageType.optionPaneId);
            return true;
        }
        if (messageType.buttons == -1) {
            JOptionPane.showMessageDialog(parent, message, messageType.title, messageType.optionPaneId);
            return true;
        }
        int ret = JOptionPane.showConfirmDialog(parent, message, messageType.title, messageType.buttons, messageType.optionPaneId);
        return ret == 0 || ret == 0;
    }

    public static boolean showMessageBox(String message, MessageType messageType, Logger logger, Throwable exception) {
        return Gui.showMessageBox(null, message, messageType, logger, exception);
    }

    public static void asyncMessageBox(final String message, final MessageType messageType, final Logger logger, final Throwable exception) {
        if (SwingUtilities.isEventDispatchThread()) {
            Gui.showMessageBox(message, messageType, logger, exception);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Gui.showMessageBox(null, message, messageType, logger, exception);
            }
        });
    }

    public static long getLastUserActivityMillis() {
        return lastUserActivity;
    }

    static {
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                lastUserActivity = System.currentTimeMillis();
            }
        }, 24L);
    }

    public static interface GuiCallable<T> {
        public T run();
    }
}

