/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui;

import java.math.BigInteger;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.openslx.dozmod.authentication.FingerprintManager;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.MessageType;

public class GraphicalCertHandler {
    private static final Logger LOGGER = Logger.getLogger(GuiTrustManager.class);
    private final String address;
    private final SSLContext sslContext;

    private GraphicalCertHandler(String address) {
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLSv1.2");
        }
        catch (NoSuchAlgorithmException e) {
            Gui.asyncMessageBox("Could not get TLSv1.2 SSL context", MessageType.ERROR, LOGGER, e);
        }
        if (ctx != null) {
            try {
                ctx.init(null, new TrustManager[]{new GuiTrustManager()}, null);
            }
            catch (KeyManagementException e) {
                Gui.asyncMessageBox("Could not initialize TLSv1.2 SSL context", MessageType.ERROR, LOGGER, e);
                ctx = null;
            }
        }
        this.sslContext = ctx;
        this.address = address;
    }

    public static SSLContext getSslContext(String address) {
        return new GraphicalCertHandler((String)address).sslContext;
    }

    private class GuiTrustManager
    implements X509TrustManager {
        private GuiTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            MessageDigest md;
            if (certs == null || certs.length == 0) {
                Boolean ret = Gui.syncExec(new Gui.GuiCallable<Boolean>(){

                    @Override
                    public Boolean run() {
                        return Gui.showMessageBox(null, "Der Satellit besitzt kein Zertifikat. Verschl\u00fcsselte Verbindung nicht m\u00f6glich.\n\nM\u00f6chten Sie trotzdem fortfahren?", MessageType.WARNING, LOGGER, null);
                    }
                });
                if (ret.booleanValue()) {
                    return;
                }
                throw new CertificateException("No certificate provided by server");
            }
            byte[] encoded = certs[0].getEncoded();
            try {
                md = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.warn("Could not get SHA-256 hash of certificate", e);
                throw new CertificateException("Could not get SHA-256 hash of certificate");
            }
            md.update(encoded);
            byte[] actualFingerprint = md.digest();
            String actualFingerprintReadable = new BigInteger(actualFingerprint).toString(16);
            byte[] expectedFingerprint = FingerprintManager.getKnownFingerprint(GraphicalCertHandler.this.address);
            if (expectedFingerprint == null) {
                expectedFingerprint = FingerprintManager.getSuggestedFingerprint(GraphicalCertHandler.this.address);
            }
            if (expectedFingerprint == null) {
                FingerprintManager.saveKnownFingerprint(GraphicalCertHandler.this.address, actualFingerprint);
                return;
            }
            if (Arrays.equals(actualFingerprint, expectedFingerprint)) {
                return;
            }
            byte[] sf = FingerprintManager.getSuggestedFingerprint(GraphicalCertHandler.this.address);
            if (sf != null && Arrays.equals(actualFingerprint, sf)) {
                FingerprintManager.saveKnownFingerprint(GraphicalCertHandler.this.address, actualFingerprint);
                return;
            }
            final String question = "!!! ALARM !!!! ALARM !!!\n\nDer Fingerabdruck von " + GraphicalCertHandler.this.address + " hat sich ver\u00e4ndert.\nErwartet: " + new BigInteger(expectedFingerprint).toString(16) + "\nVorgefunden: " + actualFingerprintReadable + "\n\nM\u00f6chten Sie trotzdem zu diesem Satelliten verbinden?";
            Boolean userOk = Gui.syncExec(new Gui.GuiCallable<Boolean>(){

                @Override
                public Boolean run() {
                    return Gui.showMessageBox(null, question, MessageType.QUESTION_YESNO, null, null);
                }
            });
            if (!userOk.booleanValue()) {
                throw new CertificateException("Rejected by user");
            }
            FingerprintManager.saveKnownFingerprint(GraphicalCertHandler.this.address, actualFingerprint);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

