/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.filetransfer;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.TransferState;
import org.openslx.dozmod.filetransfer.TransferEvent;
import org.openslx.dozmod.filetransfer.TransferEventEmitter;
import org.openslx.dozmod.filetransfer.TransferEventListener;
import org.openslx.dozmod.thrift.Session;
import org.openslx.filetransfer.Transfer;
import org.openslx.util.Util;

public abstract class TransferTask
implements Runnable,
TransferEventEmitter {
    private static final Logger LOGGER = Logger.getLogger(TransferTask.class);
    protected static final double BYTES_PER_MIB = 1048576.0;
    protected static final long CHUNK_SIZE = 0x1000000L;
    protected static final double UPDATE_INTERVAL_SECONDS = 0.6;
    protected static final int UPDATE_INTERVAL_MS = 600;
    protected final List<TransferThread> transfers = new ArrayList<TransferThread>();
    private final List<TransferThread> connectingTransfers = new ArrayList<TransferThread>();
    protected final AtomicInteger consecutiveInitFails = new AtomicInteger();
    private final List<TransferEventListener> listeners = new ArrayList<TransferEventListener>();
    private volatile boolean isComplete = false;
    private volatile boolean isCancelled = false;
    private boolean endgame = false;
    private int minConnectionCount = 1;
    private long lastConnectionAttempt = 0L;
    protected final File localFile;
    protected final long fileSize;

    protected TransferTask(File localFile, long fileSize) {
        this.localFile = localFile;
        this.fileSize = fileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (!this.isCancelled && !Thread.interrupted()) {
            TransferEvent event = this.getTransferEvent();
            if (event != null) {
                if (event.state == TransferState.FINISHED) {
                    this.isComplete = true;
                }
                if (event.state == TransferState.ERROR) {
                    this.isCancelled = true;
                }
                this.fireEvent(event);
                if (event.state == TransferState.ERROR || event.state == TransferState.FINISHED) break;
            }
            this.ensureActivity();
            Util.sleep(600);
        }
        ArrayList<TransferThread> joinList = new ArrayList<TransferThread>();
        List<TransferThread> list = this.transfers;
        synchronized (list) {
            this.isCancelled = true;
            joinList.addAll(this.transfers);
            joinList.addAll(this.connectingTransfers);
        }
        for (TransferThread t : joinList) {
            Transfer transfer = t.getTransfer();
            if (transfer != null) {
                transfer.cancel();
            }
            t.interrupt();
            Util.joinThread(t);
        }
        this.cleanup();
    }

    protected void cleanup() {
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public boolean isCanceled() {
        return this.isCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(TransferEvent event) {
        List<TransferEventListener> list = this.listeners;
        synchronized (list) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).update(event);
            }
        }
    }

    protected void fireErrorMessage(String message) {
        TransferEvent event = new TransferEvent(null, null, 0L, 0L, 0L, message);
        this.fireEvent(event);
    }

    protected abstract TransferEvent getTransferEvent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMinConnections(int count) {
        if (Session.getSatelliteConfig() != null && Session.getSatelliteConfig().isSetMaxConnectionsPerTransfer() && Session.getSatelliteConfig().getMaxConnectionsPerTransfer() > 0 && Session.getSatelliteConfig().getMaxConnectionsPerTransfer() < count) {
            count = Session.getSatelliteConfig().getMaxConnectionsPerTransfer();
        }
        List<TransferThread> list = this.transfers;
        synchronized (list) {
            this.minConnectionCount = count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TransferEventListener listener) {
        List<TransferEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(TransferEventListener listener) {
        List<TransferEventListener> list = this.listeners;
        synchronized (list) {
            while (this.listeners.remove(listener)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ArrayList<TransferThread> joiners;
        List<TransferThread> list = this.transfers;
        synchronized (list) {
            if (this.isCancelled) {
                return;
            }
            this.isCancelled = true;
            joiners = new ArrayList<TransferThread>();
            joiners.addAll(this.transfers);
            joiners.addAll(this.connectingTransfers);
        }
        for (TransferThread t : joiners) {
            if (t.getTransfer() == null) continue;
            t.getTransfer().cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensureActivity() {
        List<TransferThread> list = this.transfers;
        synchronized (list) {
            if (this.isCancelled || this.isComplete) {
                return;
            }
            if (!(!this.endgame || this.transfers.isEmpty() && this.connectingTransfers.isEmpty())) {
                return;
            }
            Iterator<TransferThread> it = this.transfers.iterator();
            while (it.hasNext()) {
                if (it.next().getTransfer().isValid()) continue;
                it.remove();
            }
            if (this.transfers.size() + this.connectingTransfers.size() >= this.minConnectionCount) {
                return;
            }
            long now = System.currentTimeMillis();
            int fails = this.consecutiveInitFails.get();
            if (this.lastConnectionAttempt + (long)(fails * 10000) > now) {
                return;
            }
            this.lastConnectionAttempt = now;
            TransferThread thread = this.createNewThread();
            if (thread != null) {
                thread.setDaemon(true);
                this.connectingTransfers.add(thread);
                thread.start();
            }
        }
    }

    protected abstract TransferThread createNewThread();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void connectFailed(TransferThread thread) {
        List<TransferThread> list = this.transfers;
        synchronized (list) {
            this.connectingTransfers.remove(thread);
            if (this.transfers.size() > 0) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void connectSucceeded(TransferThread thread) {
        List<TransferThread> list = this.transfers;
        synchronized (list) {
            this.connectingTransfers.remove(thread);
            if (!this.isCancelled) {
                this.transfers.add(thread);
                return;
            }
        }
        thread.getTransfer().cancel();
        thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void transferEnded(TransferThread thread, boolean success) {
        List<TransferThread> list = this.transfers;
        synchronized (list) {
            this.transfers.remove(thread);
            if (this.endgame && !success && this.transfers.isEmpty()) {
                LOGGER.debug("Disabled endgame mode");
                this.endgame = false;
            } else if (!this.endgame && success) {
                LOGGER.debug("Enabled endgame mode");
                this.endgame = true;
            }
            if (success && this.transfers.isEmpty()) {
                LOGGER.debug("Transfer might have finished");
                this.lastConnectionAttempt = System.currentTimeMillis() + 3000L;
                return;
            }
        }
        this.ensureActivity();
    }

    public final int getFailCount() {
        return this.consecutiveInitFails.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransferCount() {
        List<TransferThread> list = this.transfers;
        synchronized (list) {
            return this.transfers.size();
        }
    }

    public File getFile() {
        return this.localFile;
    }

    protected static abstract class TransferThread
    extends Thread {
        protected TransferThread() {
        }

        @Override
        public abstract void run();

        protected abstract Transfer getTransfer();

        public abstract long getCurrentSpeed();
    }
}

