/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.filetransfer;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.TInvalidTokenException;
import org.openslx.bwlp.thrift.iface.TransferState;
import org.openslx.bwlp.thrift.iface.TransferStatus;
import org.openslx.dozmod.filetransfer.TransferEvent;
import org.openslx.dozmod.filetransfer.TransferEventEmitter;
import org.openslx.dozmod.filetransfer.TransferEventListener;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

public class PassiveTransfer
implements TransferEventEmitter {
    private static final Logger LOGGER = Logger.getLogger(PassiveTransfer.class);
    private static final long THRIFT_INTERVAL_MS = 2000L;
    private final List<TransferEventListener> listeners = new ArrayList<TransferEventListener>();
    private final String uploadToken;
    private final boolean queryMaster;
    private long lastThriftUpdate = 0L;
    private boolean isCancelled = false;

    public PassiveTransfer(String token, boolean queryMaster) {
        this.uploadToken = token;
        this.queryMaster = queryMaster;
        QuickTimer.scheduleAtFixedDelay(new QuickTimer.Task(){

            @Override
            public void fire() {
                PassiveTransfer.this.update();
                if (PassiveTransfer.this.isCancelled) {
                    this.cancel();
                }
            }
        }, 1L, 2001L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TransferEventListener listener) {
        List<TransferEventListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(TransferEventListener listener) {
        List<TransferEventListener> list = this.listeners;
        synchronized (list) {
            while (this.listeners.remove(listener)) {
            }
        }
    }

    @Override
    public boolean isCanceled() {
        return this.isCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        long now = System.currentTimeMillis();
        if (this.lastThriftUpdate + 2000L > now) {
            return;
        }
        TransferState state = null;
        byte[] blocks = null;
        String error = null;
        this.lastThriftUpdate = now;
        try {
            TransferStatus uploadStatus = this.queryMaster ? ThriftManager.getMasterClient().queryUploadStatus(this.uploadToken) : ThriftManager.getSatClient().queryUploadStatus(this.uploadToken);
            state = uploadStatus.getState();
            blocks = uploadStatus.getBlockStatus();
        }
        catch (TInvalidTokenException e) {
            error = "Upload token unknown!?";
            state = TransferState.ERROR;
        }
        catch (TException e) {
            error = "Exception quering upload status: " + e.toString();
        }
        if (error != null) {
            error = this.queryMaster ? "Master: " : "Satellite: " + error;
        }
        TransferEvent event = new TransferEvent(state, blocks, 0L, 0L, 0L, error);
        this.isCancelled = state == null || state == TransferState.ERROR || state == TransferState.FINISHED;
        List<TransferEventListener> list = this.listeners;
        synchronized (list) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                this.listeners.get(i).update(event);
            }
        }
    }
}

