/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.filetransfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.TInvalidTokenException;
import org.openslx.dozmod.thrift.Session;
import org.openslx.filetransfer.util.FileChunk;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.GrowingThreadPoolExecutor;
import org.openslx.util.PrioThreadFactory;
import org.openslx.util.QuickTimer;
import org.openslx.util.Util;

public class AsyncHashGenerator
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(AsyncHashGenerator.class);
    private static final ThreadPoolExecutor pool = new GrowingThreadPoolExecutor(1, Runtime.getRuntime().availableProcessors(), 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(4), new PrioThreadFactory("HashGen"));
    private static final ThreadLocal<MessageDigest> sha1 = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.warn("No SHA-1 MD available. Cannot hash file", e);
                return null;
            }
        }
    };
    private String uploadToken = null;
    private int finishedBlocks = 0;
    private final RandomAccessFile file;
    private final List<ByteBuffer> blockHashes;
    private final List<FileChunk> list;
    private volatile boolean isCanceled = false;

    public AsyncHashGenerator(File uploadFile) throws FileNotFoundException, NoSuchAlgorithmException {
        try {
            this.file = new RandomAccessFile(uploadFile, "r");
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not open file for hash-checking. Will not send checksums to satellite", e);
            throw e;
        }
        this.list = new ArrayList<FileChunk>();
        FileChunk.createChunkList(this.list, uploadFile.length(), null);
        this.blockHashes = new ArrayList<ByteBuffer>(this.list.size());
        this.setDaemon(true);
        this.setName("HashGenerator");
    }

    public void setUploadToken(String token) {
        if (!this.isCanceled && this.uploadToken == null) {
            this.uploadToken = token;
            this.submitHashes(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block12: {
            block13: {
                try {
                    block7: for (FileChunk chunk : this.list) {
                        Block block;
                        if (this.isCanceled) {
                            LOGGER.debug("Cancelled chunk reader (1)");
                            break block12;
                        }
                        try {
                            byte[] buffer = new byte[chunk.range.getLength()];
                            this.file.seek(chunk.range.startOffset);
                            this.file.readFully(buffer);
                            block = new Block(chunk, buffer);
                        }
                        catch (IOException e) {
                            LOGGER.warn("Could not read file chunk " + chunk.getChunkIndex() + ", skipping", e);
                            block = new Block(chunk, new byte[0]);
                        }
                        if (this.isCanceled) {
                            LOGGER.debug("Cancelled chunk reader (2)");
                            break block12;
                        }
                        while (true) {
                            if (pool.isTerminating() || pool.isTerminated()) {
                                Thread.currentThread().interrupt();
                                break block13;
                            }
                            try {
                                pool.execute(block);
                                if (this.uploadToken != null || chunk.range.startOffset <= 0x4000000L) continue block7;
                                Util.sleep(200);
                                continue block7;
                            }
                            catch (RejectedExecutionException e) {
                                Util.sleep(100);
                                continue;
                            }
                            break;
                        }
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Util.safeClose(this.file);
                    throw throwable;
                }
            }
            Util.safeClose(this.file);
            return;
        }
        Util.safeClose(this.file);
    }

    public void cancel() {
        LOGGER.debug("Cancelled externally");
        this.isCanceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hashDone(FileChunk chunk, byte[] hash) {
        int blockIndex = chunk.getChunkIndex();
        List<ByteBuffer> list = this.blockHashes;
        synchronized (list) {
            while (this.blockHashes.size() < blockIndex) {
                this.blockHashes.add(null);
            }
            if (this.blockHashes.size() == blockIndex) {
                this.blockHashes.add(ByteBuffer.wrap(hash));
            } else {
                this.blockHashes.set(blockIndex, ByteBuffer.wrap(hash));
            }
            if (blockIndex == this.finishedBlocks) {
                while (this.finishedBlocks < this.blockHashes.size() && this.blockHashes.get(this.finishedBlocks) != null) {
                    ++this.finishedBlocks;
                }
            }
        }
        if (blockIndex % 20 == 0 || this.finishedBlocks == this.list.size()) {
            if (blockIndex + 1 == this.list.size()) {
                LOGGER.debug("Hashing done");
                for (int i = 0; i < 10; ++i) {
                    if (this.submitHashes(true)) {
                        LOGGER.debug("Hashes sent to server");
                        break;
                    }
                    LOGGER.debug("Sending hashes failed...");
                    try {
                        Thread.sleep(2000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        this.interrupt();
                        return;
                    }
                }
                return;
            }
            QuickTimer.scheduleOnce(new QuickTimer.Task(){

                @Override
                public void fire() {
                    if (!AsyncHashGenerator.this.submitHashes(false)) {
                        LOGGER.warn("Server rejected block hash list");
                        AsyncHashGenerator.this.isCanceled = true;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean submitHashes(boolean mustSucceed) {
        block7: {
            ArrayList<ByteBuffer> subList;
            List<ByteBuffer> list = this.blockHashes;
            synchronized (list) {
                subList = new ArrayList<ByteBuffer>(this.blockHashes.subList(0, this.finishedBlocks));
            }
            if (this.uploadToken == null || subList.isEmpty()) {
                return true;
            }
            try {
                ThriftManager.getSatClient().updateBlockHashes(this.uploadToken, subList, Session.getSatelliteToken());
            }
            catch (TInvalidTokenException e) {
                LOGGER.warn("Cannot send hashList to satellite: Sat claims uploadToken is invalid!");
                this.isCanceled = true;
                return false;
            }
            catch (TException e) {
                LOGGER.warn("Unknown exception when submitting hashList to sat", e);
                if (!mustSucceed) break block7;
                return false;
            }
        }
        return true;
    }

    private class Block
    implements Runnable {
        public final FileChunk chunk;
        public final byte[] buffer;

        public Block(FileChunk chunk, byte[] buffer) {
            this.chunk = chunk;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            MessageDigest digester = (MessageDigest)sha1.get();
            digester.update(this.buffer, 0, this.chunk.range.getLength());
            byte[] hash = digester.digest();
            AsyncHashGenerator.this.hashDone(this.chunk, hash);
        }
    }
}

