/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.authentication;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.openslx.dozmod.Config;

public class FingerprintManager {
    private static final Logger LOGGER = Logger.getLogger(FingerprintManager.class);
    private static final File file = new File(Config.getPath(), "fingerprints.properties");
    private static final Properties prop = new Properties();

    public static void saveKnownFingerprint(String address, byte[] fingerprint) {
        if (FingerprintManager.saveFingerprint(address, fingerprint, true)) {
            FingerprintManager.store();
        }
    }

    public static void saveSuggestedFingerprint(String address, byte[] fingerprint) {
        FingerprintManager.saveFingerprint(address, fingerprint, false);
        prop.setProperty(address + "_master", Base64.encodeBase64String(fingerprint));
        FingerprintManager.store();
    }

    private static boolean saveFingerprint(String address, byte[] fingerprint, boolean replace) {
        if (replace || !prop.containsKey(address)) {
            prop.setProperty(address, Base64.encodeBase64String(fingerprint));
            return true;
        }
        return false;
    }

    private static void store() {
        try {
            prop.store(new FileOutputStream(file), "Written by bwLehrstuhl");
        }
        catch (IOException e) {
            LOGGER.warn("Could not store fingerprint");
        }
    }

    public static byte[] getKnownFingerprint(String address) {
        return Base64.decodeBase64(prop.getProperty(address));
    }

    public static byte[] getSuggestedFingerprint(String address) {
        return Base64.decodeBase64(prop.getProperty(address + "_master"));
    }

    static {
        if (file.exists()) {
            try {
                prop.load(new FileInputStream(file));
            }
            catch (IOException e) {
                LOGGER.warn("Could not load cached fingerprints from " + file.toString());
            }
        }
    }
}

