/*
 * Decompiled with CFR 0.152.
 */
package org.jdatepicker;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdatepicker.ComponentColorDefaults;
import org.jdatepicker.ComponentIconDefaults;
import org.jdatepicker.DateComponentFormatter;
import org.jdatepicker.DateModel;
import org.jdatepicker.DatePanel;
import org.jdatepicker.DatePicker;
import org.jdatepicker.JDatePanel;
import org.jdatepicker.UtilCalendarModel;
import org.jdatepicker.constraints.DateSelectionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDatePicker
extends JComponent
implements DatePicker {
    private static final long serialVersionUID = 2814777654384974503L;
    private Popup popup;
    private JFormattedTextField formattedTextField;
    private JButton button;
    private JDatePanel datePanel;

    public JDatePicker() {
        this(new JDatePanel());
    }

    public JDatePicker(Calendar value) {
        this(new JDatePanel(value));
    }

    public JDatePicker(java.util.Date value) {
        this(new JDatePanel(value));
    }

    public JDatePicker(Date value) {
        this(new JDatePanel(value));
    }

    public JDatePicker(DateModel<?> model) {
        this(new JDatePanel(model));
    }

    private JDatePicker(JDatePanel datePanel) {
        this.datePanel = datePanel;
        this.popup = null;
        datePanel.setBorder(BorderFactory.createLineBorder(JDatePicker.getColors().getColor(ComponentColorDefaults.Key.POPUP_BORDER)));
        InternalEventHandler internalEventHandler = new InternalEventHandler();
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.formattedTextField = new JFormattedTextField(new DateComponentFormatter());
        DateModel<?> model = datePanel.getModel();
        this.setTextFieldValue(this.formattedTextField, model.getYear(), model.getMonth(), model.getDay(), model.isSelected());
        this.formattedTextField.setEditable(false);
        this.add(this.formattedTextField);
        layout.putConstraint("West", (Component)this.formattedTextField, 0, "West", (Component)this);
        layout.putConstraint("South", (Component)this, 0, "South", (Component)this.formattedTextField);
        this.button = new JButton();
        this.button.setFocusable(true);
        Icon icon = ComponentIconDefaults.getInstance().getPopupButtonIcon();
        this.button.setIcon(icon);
        if (icon == null) {
            this.button.setText("...");
        } else {
            this.button.setText("");
        }
        this.add(this.button);
        layout.putConstraint("West", (Component)this.button, 1, "East", (Component)this.formattedTextField);
        layout.putConstraint("East", (Component)this, 0, "East", (Component)this.button);
        layout.putConstraint("South", (Component)this, 0, "South", (Component)this.button);
        int h = (int)this.button.getPreferredSize().getHeight();
        int w = (int)datePanel.getPreferredSize().getWidth();
        this.button.setPreferredSize(new Dimension(h, h));
        this.formattedTextField.setPreferredSize(new Dimension(w - h - 1, h));
        this.addHierarchyBoundsListener(internalEventHandler);
        this.button.addActionListener(internalEventHandler);
        this.formattedTextField.addPropertyChangeListener("value", internalEventHandler);
        datePanel.addActionListener(internalEventHandler);
        datePanel.getModel().addChangeListener(internalEventHandler);
        long eventMask = 501L;
        Toolkit.getDefaultToolkit().addAWTEventListener(internalEventHandler, eventMask);
    }

    private static ComponentColorDefaults getColors() {
        return ComponentColorDefaults.getInstance();
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this.datePanel.addActionListener(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this.datePanel.removeActionListener(actionListener);
    }

    @Override
    public DateModel<?> getModel() {
        return this.datePanel.getModel();
    }

    @Override
    public void setTextEditable(boolean editable) {
        this.formattedTextField.setEditable(editable);
    }

    @Override
    public boolean isTextEditable() {
        return this.formattedTextField.isEditable();
    }

    @Override
    public void setButtonFocusable(boolean focusable) {
        this.button.setFocusable(focusable);
    }

    @Override
    public boolean getButtonFocusable() {
        return this.button.isFocusable();
    }

    public DatePanel getJDateInstantPanel() {
        return this.datePanel;
    }

    private void showPopup() {
        if (this.popup == null) {
            PopupFactory fac = new PopupFactory();
            Point xy = this.getLocationOnScreen();
            this.datePanel.setVisible(true);
            this.popup = fac.getPopup(this, this.datePanel, (int)xy.getX(), (int)(xy.getY() + (double)this.getHeight()));
            this.popup.show();
        }
    }

    private void hidePopup() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    private Set<Component> getAllComponents(Component component) {
        HashSet<Component> children = new HashSet<Component>();
        children.add(component);
        if (component instanceof Container) {
            Container container = (Container)component;
            Component[] components = container.getComponents();
            for (int i = 0; i < components.length; ++i) {
                children.addAll(this.getAllComponents(components[i]));
            }
        }
        return children;
    }

    @Override
    public boolean isDoubleClickAction() {
        return this.datePanel.isDoubleClickAction();
    }

    @Override
    public boolean isShowYearButtons() {
        return this.datePanel.isShowYearButtons();
    }

    @Override
    public void setDoubleClickAction(boolean doubleClickAction) {
        this.datePanel.setDoubleClickAction(doubleClickAction);
    }

    @Override
    public void setShowYearButtons(boolean showYearButtons) {
        this.datePanel.setShowYearButtons(showYearButtons);
    }

    private void setTextFieldValue(JFormattedTextField textField, int year, int month, int day, boolean isSelected) {
        if (!isSelected) {
            textField.setValue(null);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.set(year, month, day, 0, 0, 0);
            calendar.set(14, 0);
            textField.setValue(calendar);
        }
    }

    @Override
    public void addDateSelectionConstraint(DateSelectionConstraint constraint) {
        this.datePanel.addDateSelectionConstraint(constraint);
    }

    @Override
    public void removeDateSelectionConstraint(DateSelectionConstraint constraint) {
        this.datePanel.removeDateSelectionConstraint(constraint);
    }

    @Override
    public void removeAllDateSelectionConstraints() {
        this.datePanel.removeAllDateSelectionConstraints();
    }

    @Override
    public Set<DateSelectionConstraint> getDateSelectionConstraints() {
        return this.datePanel.getDateSelectionConstraints();
    }

    @Override
    public int getTextfieldColumns() {
        return this.formattedTextField.getColumns();
    }

    @Override
    public void setTextfieldColumns(int columns) {
        this.formattedTextField.setColumns(columns);
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (!aFlag) {
            this.hidePopup();
        }
        super.setVisible(aFlag);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
        this.datePanel.setEnabled(enabled);
        this.formattedTextField.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    private class InternalEventHandler
    implements ActionListener,
    HierarchyBoundsListener,
    ChangeListener,
    PropertyChangeListener,
    AWTEventListener {
        private InternalEventHandler() {
        }

        public void ancestorMoved(HierarchyEvent arg0) {
            JDatePicker.this.hidePopup();
        }

        public void ancestorResized(HierarchyEvent arg0) {
            JDatePicker.this.hidePopup();
        }

        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource() == JDatePicker.this.button) {
                if (JDatePicker.this.popup == null) {
                    JDatePicker.this.showPopup();
                } else {
                    JDatePicker.this.hidePopup();
                }
            } else if (arg0.getSource() == JDatePicker.this.datePanel) {
                JDatePicker.this.hidePopup();
            }
        }

        public void stateChanged(ChangeEvent arg0) {
            if (arg0.getSource() == JDatePicker.this.datePanel.getModel()) {
                DateModel<?> model = JDatePicker.this.datePanel.getModel();
                JDatePicker.this.setTextFieldValue(JDatePicker.this.formattedTextField, model.getYear(), model.getMonth(), model.getDay(), model.isSelected());
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getOldValue() == null && evt.getNewValue() == null) {
                return;
            }
            if (evt.getOldValue() != null && evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            if (!JDatePicker.this.formattedTextField.isEditable()) {
                return;
            }
            if (evt.getNewValue() != null) {
                Calendar value = (Calendar)evt.getNewValue();
                UtilCalendarModel model = new UtilCalendarModel(value);
                if (!JDatePicker.this.datePanel.checkConstraints(model)) {
                    JDatePicker.this.formattedTextField.setValue(evt.getOldValue());
                    return;
                }
                JDatePicker.this.datePanel.getModel().setDate(value.get(1), value.get(2), value.get(5));
                JDatePicker.this.datePanel.getModel().setSelected(true);
            }
            if (evt.getNewValue() == null) {
                JDatePicker.this.getModel().setSelected(false);
            }
        }

        public void eventDispatched(AWTEvent event) {
            if (500 == event.getID() && event.getSource() != JDatePicker.this.button) {
                Set components = JDatePicker.this.getAllComponents(JDatePicker.this.datePanel);
                boolean clickInPopup = false;
                for (Component component : components) {
                    if (event.getSource() != component) continue;
                    clickInPopup = true;
                }
                if (!clickInPopup) {
                    JDatePicker.this.hidePopup();
                }
            }
        }
    }
}

