/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.search.env;

import com.btr.proxy.search.ProxySearchStrategy;
import com.btr.proxy.selector.fixed.FixedProxySelector;
import com.btr.proxy.selector.misc.ProtocolDispatchSelector;
import com.btr.proxy.selector.whitelist.ProxyBypassListSelector;
import com.btr.proxy.util.Logger;
import com.btr.proxy.util.ProxyUtil;
import java.net.ProxySelector;
import java.util.Properties;

public class EnvProxySearchStrategy
implements ProxySearchStrategy {
    private String httpEnv;
    private String httpsEnv;
    private String ftpEnv;
    private String noProxyEnv;
    private String httpProxy;
    private String httpsProxy;
    private String ftpProxy;
    private String noProxy;

    public EnvProxySearchStrategy() {
        this("http_proxy", "https_proxy", "ftp_proxy", "no_proxy");
    }

    public EnvProxySearchStrategy(String httpEnv, String httpsEnv, String ftpEnv, String noProxyEnv) {
        this.httpEnv = httpEnv;
        this.httpsEnv = httpsEnv;
        this.ftpEnv = ftpEnv;
        this.noProxyEnv = noProxyEnv;
        this.loadProxySettings();
    }

    private void loadProxySettings() {
        this.httpProxy = System.getenv(this.httpEnv);
        this.httpsProxy = System.getenv(this.httpsEnv);
        this.ftpProxy = System.getenv(this.ftpEnv);
        this.noProxy = System.getenv(this.noProxyEnv);
    }

    public Properties readSettings() {
        Properties result = new Properties();
        result.setProperty(this.httpEnv, this.httpProxy);
        result.setProperty(this.httpsEnv, this.httpsProxy);
        result.setProperty(this.ftpEnv, this.ftpProxy);
        result.setProperty(this.noProxyEnv, this.noProxy);
        return result;
    }

    @Override
    public ProxySelector getProxySelector() {
        FixedProxySelector ftpPS;
        FixedProxySelector httpsPS;
        Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Inspecting environment variables.", new Object[0]);
        ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
        FixedProxySelector httpPS = ProxyUtil.parseProxySettings(this.httpProxy);
        if (httpPS != null) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Http Proxy is {0}", this.httpProxy);
            ps.setSelector("http", httpPS);
        }
        if ((httpsPS = ProxyUtil.parseProxySettings(this.httpsProxy)) != null) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Https Proxy is {0}", this.httpsProxy);
            ps.setSelector("https", httpsPS);
        }
        if ((ftpPS = ProxyUtil.parseProxySettings(this.ftpProxy)) != null) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Ftp Proxy is {0}", this.ftpProxy);
            ps.setSelector("ftp", ftpPS);
        }
        ps.setFallbackSocksSelector(httpPS, httpsPS, ftpPS);
        if (ps.isEmpty()) {
            return null;
        }
        ProxySelector result = ps;
        if (this.noProxy != null && this.noProxy.trim().length() > 0) {
            Logger.log(this.getClass(), Logger.LogLevel.TRACE, "Using proxy bypass list: {0}", this.noProxy);
            result = new ProxyBypassListSelector(this.noProxy, (ProxySelector)ps);
        }
        return result;
    }
}

