/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.filetransfer.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;
import org.openslx.filetransfer.FileRange;
import org.openslx.filetransfer.LocalChunkSource;
import org.openslx.filetransfer.util.ChunkStatus;

public class FileChunk {
    private static final Logger LOGGER = Logger.getLogger(FileChunk.class);
    public static final int SHA1_LENGTH = 20;
    public static final int CHUNK_SIZE_MIB = 16;
    public static final int CHUNK_SIZE = 0x1000000;
    public final FileRange range;
    private int failCount = 0;
    protected byte[] sha1sum;
    protected CRC32 crc32;
    protected ChunkStatus status = ChunkStatus.MISSING;
    private boolean writtenToDisk = false;
    private LocalChunkSource.ChunkSource localSource = null;
    static final byte[] NULL_BLOCK_SHA1 = new byte[]{59, 68, 23, -4, 66, 28, -18, 48, -87, -83, 15, -39, 49, -110, 32, -88, -38, -29, 45, -94};
    static final long NULL_BLOCK_CRC32 = 2759631178L;

    public FileChunk(long startOffset, long endOffset, byte[] sha1sum) {
        this.range = new FileRange(startOffset, endOffset);
        this.sha1sum = (byte[])(sha1sum == null || sha1sum.length != 20 ? null : sha1sum);
    }

    synchronized boolean setSha1Sum(byte[] sha1sum) {
        if (this.sha1sum != null || sha1sum == null || sha1sum.length != 20) {
            return false;
        }
        this.sha1sum = sha1sum;
        if (Arrays.equals(sha1sum, NULL_BLOCK_SHA1)) {
            this.writtenToDisk = true;
            if (this.crc32 == null) {
                this.crc32 = new CRC32(){

                    @Override
                    public long getValue() {
                        return 2759631178L;
                    }
                };
            }
            return true;
        }
        if (this.status == ChunkStatus.COMPLETE) {
            this.status = ChunkStatus.HASHING;
        }
        return true;
    }

    synchronized int incFailed() {
        return ++this.failCount;
    }

    public int getChunkIndex() {
        return (int)(this.range.startOffset / 0x1000000L);
    }

    public String toString() {
        return "[Chunk " + this.getChunkIndex() + " (" + (Object)((Object)this.status) + "), fails: " + this.failCount + "]";
    }

    public synchronized byte[] getSha1Sum() {
        return this.sha1sum;
    }

    public synchronized ChunkStatus getStatus() {
        return this.status;
    }

    public synchronized void calculateDnbd3Crc32(byte[] data) {
        long old = Long.MAX_VALUE;
        if (this.crc32 == null) {
            this.crc32 = new CRC32();
        } else {
            LOGGER.info("Redoing CRC32 of Chunk " + this.getChunkIndex());
            old = this.crc32.getValue();
            this.crc32.reset();
        }
        int expectedLength = this.range.getLength();
        if (expectedLength > data.length) {
            LOGGER.error("Chunk #" + this.getChunkIndex() + ": " + data.length + " instead of " + expectedLength + " for " + this.getChunkIndex());
        }
        this.crc32.update(data, 0, expectedLength);
        if (expectedLength % 4096 != 0) {
            LOGGER.debug("Block " + this.getChunkIndex() + " not multiple of 4k.");
            byte[] padding = new byte[4096 - expectedLength % 4096];
            this.crc32.update(padding);
        }
        if (old != Long.MAX_VALUE && old != this.crc32.getValue()) {
            LOGGER.warn(String.format("Changed from %x to %x", old, this.crc32.getValue()));
        }
    }

    public synchronized void getCrc32Le(byte[] buffer, int offset) {
        if (this.crc32 == null) {
            throw new IllegalStateException("Trying to get CRC32 on Chunk that doesn't have one");
        }
        int value = (int)this.crc32.getValue();
        buffer[offset + 3] = (byte)(value >>> 24);
        buffer[offset + 2] = (byte)(value >>> 16);
        buffer[offset + 1] = (byte)(value >>> 8);
        buffer[offset + 0] = (byte)value;
    }

    public synchronized boolean isWrittenToDisk() {
        return this.writtenToDisk;
    }

    synchronized void setStatus(ChunkStatus status) {
        if (status != null) {
            if (status == ChunkStatus.COMPLETE) {
                this.writtenToDisk = true;
            } else if (status == ChunkStatus.MISSING || status == ChunkStatus.QUEUED_FOR_COPY) {
                this.writtenToDisk = false;
            }
            this.status = status;
        }
    }

    public static int fileSizeToChunkCount(long fileSize) {
        return (int)((fileSize + 0x1000000L - 1L) / 0x1000000L);
    }

    public static void createChunkList(List<FileChunk> list, long fileSize, List<byte[]> sha1Sums) {
        if (fileSize < 0L) {
            throw new IllegalArgumentException("fileSize cannot be negative");
        }
        if (!list.isEmpty()) {
            throw new IllegalArgumentException("Passed list is not empty");
        }
        long offset = 0L;
        Iterator<byte[]> hashIt = null;
        if (sha1Sums != null) {
            hashIt = sha1Sums.iterator();
        }
        while (offset < fileSize) {
            long end = offset + 0x1000000L;
            if (end > fileSize) {
                end = fileSize;
            }
            byte[] hash = null;
            if (hashIt != null && hashIt.hasNext()) {
                hash = hashIt.next();
            }
            list.add(new FileChunk(offset, end, hash));
            offset = end;
        }
    }

    public int getFailCount() {
        return this.failCount;
    }

    public void setSource(LocalChunkSource.ChunkSource src) {
        this.localSource = src;
    }

    public LocalChunkSource.ChunkSource getSources() {
        return this.localSource;
    }
}

