/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.thrift;

import java.awt.Frame;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;
import org.openslx.bwlp.thrift.iface.AuthorizationError;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.dozmod.Config;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.thrift.ThriftError;
import org.openslx.thrifthelper.ThriftManager;

public class GuiErrorCallback
implements ThriftManager.ErrorCallback {
    private static final Logger LOGGER = Logger.getLogger(GuiErrorCallback.class);
    private final Frame parent;
    private final String serverString;

    public GuiErrorCallback(Frame parent, String serverString) {
        this.parent = parent;
        this.serverString = serverString;
    }

    @Override
    public boolean thriftError(int failCount, final String method, final Throwable t) {
        TAuthorizationException taex;
        if (t != null && !(t instanceof TException)) {
            return false;
        }
        if (failCount == 1) {
            return true;
        }
        if (ThriftError.failSilently(method)) {
            return failCount == 2;
        }
        if (t instanceof TAuthorizationException && ((taex = (TAuthorizationException)t).getNumber() == AuthorizationError.NOT_AUTHENTICATED || taex.getNumber() == AuthorizationError.INVALID_TOKEN)) {
            return Gui.syncExec(new Gui.GuiCallable<Boolean>(){

                @Override
                public Boolean run() {
                    if (Gui.showMessageBox(GuiErrorCallback.this.parent, "Ung\u00fcltiges Sitzungstoken oder fehlerhafte Authentifizierung am " + GuiErrorCallback.this.serverString + "!\nBitte starten Sie das Programm neu. Jetzt beenden?", MessageType.ERROR_RETRY, LOGGER, t)) {
                        Config.saveCurrentSession("", "", "");
                        Gui.exit(0);
                    }
                    return false;
                }
            });
        }
        if (t instanceof TTransportException) {
            final TTransportException tex = (TTransportException)t;
            return Gui.syncExec(new Gui.GuiCallable<Boolean>(){

                @Override
                public Boolean run() {
                    String errMsg = null;
                    if (tex != null) {
                        errMsg = " (Fehler " + tex.getType() + ")";
                    }
                    return Gui.showMessageBox(GuiErrorCallback.this.parent, "Die Kommunikation mit " + GuiErrorCallback.this.serverString + " ist gest\u00f6rt. Der Aufruf der Funktion " + method + " ist fehlgeschlagen" + errMsg + ".\n\nM\u00f6chten Sie den Aufruf wiederholen?", MessageType.ERROR_RETRY, LOGGER, t);
                }
            });
        }
        return false;
    }
}

