/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard.page;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.OperatingSystem;
import org.openslx.bwlp.thrift.iface.ShareMode;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.helper.TextChangeListener;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.layout.ImageMetaDataPageLayout;
import org.openslx.dozmod.state.UploadWizardState;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.cache.MetaDataCache;
import org.openslx.thrifthelper.Comparators;
import org.openslx.util.QuickTimer;
import org.openslx.util.vm.QemuMetaData;

public class ImageMetaDataPage
extends ImageMetaDataPageLayout {
    private static final Logger LOGGER = Logger.getLogger(ImageMetaDataPage.class);
    private UploadWizardState state;

    public ImageMetaDataPage(Wizard wizard, UploadWizardState uploadWizardState) {
        super(wizard);
        this.state = uploadWizardState;
        this.setPageComplete(false);
        uploadWizardState.shareMode = ShareMode.LOCAL;
        this.chkIsTemplate.setEnabled(Session.isSuperUser());
        QuickTimer.scheduleOnce(new QuickTimer.Task(){
            List<OperatingSystem> osList = null;

            @Override
            public void fire() {
                this.osList = MetaDataCache.getOperatingSystems();
                Gui.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImageMetaDataPage.this.fillOsCombo(osList);
                    }
                });
            }
        });
        this.cboOperatingSystem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ImageMetaDataPage.this.reactToUserInput();
                }
            }
        });
        this.txtDescription.getDocument().addDocumentListener(new TextChangeListener(){

            @Override
            public void changed() {
                ImageMetaDataPage.this.reactToUserInput();
            }
        });
    }

    @Override
    protected void onPageEnter() {
        if (this.state.detectedOs != null) {
            this.cboOperatingSystem.setSelectedItem(this.state.detectedOs);
        } else if (this.state.selectedOs == null) {
            this.cboOperatingSystem.setSelectedItem(null);
        }
        this.sCommandCaption.setVisible(false);
        this.startCommandPane.setVisible(false);
        this.chkIsTemplate.setSelected(this.state.isTemplate);
        this.chkLicenseRestricted.setSelected(this.state.isRestricted);
        this.reactToUserInput();
    }

    @Override
    protected boolean wantNextOrFinish() {
        this.state.selectedOs = (OperatingSystem)this.cboOperatingSystem.getSelectedItem();
        this.state.isTemplate = this.chkIsTemplate.isSelected();
        this.state.isRestricted = this.chkLicenseRestricted.isSelected();
        return this.state.selectedOs != null && this.state.description != null;
    }

    private void fillOsCombo(List<OperatingSystem> osList) {
        Collections.sort(osList, Comparators.operatingSystemByName);
        for (OperatingSystem os : osList) {
            this.cboOperatingSystem.addItem(os);
        }
    }

    private void reactToUserInput() {
        if (this.cboOperatingSystem.getSelectedIndex() == -1) {
            this.setWarningMessage("W\u00e4hlen Sie das Betriebssystem aus.");
            this.setPageComplete(false);
            return;
        }
        if (this.state.meta instanceof QemuMetaData) {
            this.sCommandCaption.setVisible(true);
            this.startCommandPane.setVisible(true);
        }
        this.state.description = this.txtDescription.getText();
        if (this.state.description == null || this.state.description.isEmpty()) {
            this.setWarningMessage("F\u00fcgen Sie eine Beschreibung hinzu.");
            this.setPageComplete(false);
            return;
        }
        this.setDescription("Klicken Sie auf 'Weiter' um Berechtigungen festzulegen oder 'Fertigstellen'");
        this.setPageComplete(true);
    }
}

