/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.wizard.page;

import java.util.Map;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.ImagePermissions;
import org.openslx.dozmod.gui.wizard.Wizard;
import org.openslx.dozmod.gui.wizard.layout.ImageCustomPermissionPageLayout;
import org.openslx.dozmod.state.UploadWizardState;
import org.openslx.dozmod.thrift.Session;

public class ImageCustomPermissionPage
extends ImageCustomPermissionPageLayout {
    private static final Logger LOGGER = Logger.getLogger(ImageCustomPermissionPage.class);
    private boolean initDone = false;
    private UploadWizardState state = null;

    public ImageCustomPermissionPage(Wizard wizard, UploadWizardState uploadWizardState) {
        super(wizard);
        this.setPageComplete(true);
        this.state = uploadWizardState;
        this.chkPermissionLink.setSelected(this.state.defaultPermissions.link);
        this.chkPermissionRead.setSelected(this.state.defaultPermissions.download);
        this.chkPermissionEdit.setSelected(this.state.defaultPermissions.edit);
        this.chkPermissionAdmin.setSelected(this.state.defaultPermissions.admin);
    }

    @Override
    protected void onPageEnter() {
        if (!this.initDone) {
            this.imageCustomPermissionManager.initPanel(this.state.permissionMap, this.state.defaultPermissions, Session.getUserId());
            this.initDone = true;
        }
    }

    @Override
    protected boolean wantNextOrFinish() {
        LOGGER.debug("Saving permissions to state ...");
        this.state.defaultPermissions = new ImagePermissions(this.chkPermissionLink.isSelected(), this.chkPermissionRead.isSelected(), this.chkPermissionEdit.isSelected(), this.chkPermissionAdmin.isSelected());
        Map<String, ImagePermissions> newPermissionMap = this.imageCustomPermissionManager.getPermissions();
        if (newPermissionMap == null || newPermissionMap.isEmpty()) {
            return super.wantNextOrFinish();
        }
        this.state.permissionMap = newPermissionMap;
        return super.wantNextOrFinish();
    }
}

