/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.ComboBox;
import org.openslx.dozmod.gui.control.WordWrapLabel;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.util.vm.VmMetaData;

public class VirtDropDownConfigEditorWindowLayout
extends JDialog {
    private static String title = "VM-Konfiguration Editor";
    protected final JScrollPane pnlScrollPane;
    protected final JEditorPane pnlEditor;
    protected final JButton btnSave;
    protected final JButton btnCancel;
    protected final JButton btnMore;
    protected final JComboBox<VmMetaData.SoundCardType> cboSound;
    protected final JComboBox<VmMetaData.DDAcceleration> cbo3DAcceleration;
    protected final JComboBox<VmMetaData.HWVersion> cboHWVersion;
    protected final JComboBox<VmMetaData.EthernetDevType> cboE0VirtDev;

    protected VirtDropDownConfigEditorWindowLayout(Window modalParent) {
        super(modalParent, title, modalParent != null ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        GridManager grid = new GridManager(this.getContentPane(), 2, true, new Insets(2, 2, 2, 2));
        JPanel pnlWarning = new JPanel();
        pnlWarning.setBorder(BorderFactory.createTitledBorder("WARNUNG"));
        pnlWarning.setLayout(new BorderLayout());
        pnlWarning.add((Component)new WordWrapLabel("Hier k\u00f6nnen Sie einige Einstellungen bzgl. der verwendeten virtuallen Hardware \u00e4ndern. Bitte beachten Sie, dass \u00c4nderungen erfordern k\u00f6nnen, dass in der VM neue Treiber vorhanden sein m\u00fcssen. In diesem Fall ist es notwendig, dass Sie die \u00c4nderung nach dem Herunterladen einer VM lokal durchf\u00fchren, die notwendigen Treiber installieren, und die VM wieder hochladen."), "Center");
        this.cboSound = new ComboBox<VmMetaData.SoundCardType>(new ComboBox.ComboBoxRenderer<VmMetaData.SoundCardType>(){

            @Override
            public String renderItem(VmMetaData.SoundCardType item) {
                return item.displayName;
            }
        });
        this.cbo3DAcceleration = new ComboBox<VmMetaData.DDAcceleration>(new ComboBox.ComboBoxRenderer<VmMetaData.DDAcceleration>(){

            @Override
            public String renderItem(VmMetaData.DDAcceleration item) {
                return item.displayName;
            }
        });
        this.cboHWVersion = new ComboBox<VmMetaData.HWVersion>(new ComboBox.ComboBoxRenderer<VmMetaData.HWVersion>(){

            @Override
            public String renderItem(VmMetaData.HWVersion item) {
                return item.displayName;
            }
        });
        this.cboE0VirtDev = new ComboBox<VmMetaData.EthernetDevType>(new ComboBox.ComboBoxRenderer<VmMetaData.EthernetDevType>(){

            @Override
            public String renderItem(VmMetaData.EthernetDevType item) {
                return item.displayName;
            }
        });
        this.pnlEditor = new JEditorPane("text/plain", null);
        this.pnlScrollPane = new JScrollPane(this.pnlEditor, 20, 31);
        grid.add(pnlWarning, 2).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.add(new JLabel("Soundkarte")).fill(true, false).expand(false, false);
        grid.add(this.cboSound).fill(true, false).expand(false, false);
        grid.nextRow();
        grid.add(new JLabel("3D-Beschleunigung")).fill(true, false).expand(false, false);
        grid.add(this.cbo3DAcceleration).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.add(new JLabel("VMWare HW-Version")).fill(true, false).expand(false, false);
        grid.add(this.cboHWVersion).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.add(new JLabel("Netzwerkkarte")).fill(true, false).expand(false, false);
        grid.add(this.cboE0VirtDev).fill(true, false).expand(true, false);
        grid.nextRow();
        grid.add(Box.createVerticalGlue(), 2).expand(true, true);
        grid.nextRow();
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPane.add(Box.createHorizontalGlue());
        this.btnMore = new JButton("Expertenmodus");
        buttonPane.add(this.btnMore);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        this.btnCancel = new JButton("Abbrechen");
        buttonPane.add(this.btnCancel);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        this.btnSave = new JButton("Speichern");
        buttonPane.add(this.btnSave);
        grid.add(buttonPane, 2).fill(true, false).expand(true, false);
        grid.finish(false);
        this.setPreferredSize(Gui.getScaledDimension(600, 400));
        this.setMinimumSize(Gui.getScaledDimension(450, 350));
        if (modalParent != null) {
            Gui.centerShellOverShell(modalParent, this);
        }
    }

    public void initializeSoundBox(List<VmMetaData.SoundCardType> list) {
        for (VmMetaData.SoundCardType i : list) {
            this.cboSound.addItem(i);
        }
    }

    public void initializeDDABox(List<VmMetaData.DDAcceleration> list) {
        for (VmMetaData.DDAcceleration i : list) {
            this.cbo3DAcceleration.addItem(i);
        }
    }

    public void initializeHWVersBox(List<VmMetaData.HWVersion> list) {
        for (VmMetaData.HWVersion i : list) {
            this.cboHWVersion.addItem(i);
        }
    }

    public void initializeEDTBox(List<VmMetaData.EthernetDevType> list) {
        for (VmMetaData.EthernetDevType i : list) {
            this.cboE0VirtDev.addItem(i);
        }
    }
}

