/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window.layout;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.Organization;
import org.openslx.dozmod.Branding;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.control.ComboBox;
import org.openslx.dozmod.gui.control.QLabel;
import org.openslx.dozmod.gui.helper.GridManager;
import org.openslx.dozmod.util.ResourceLoader;

public abstract class LoginWindowLayout
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(LoginWindowLayout.class);
    protected LOGIN_TYPE loginType = null;
    private static final String TITLE = Branding.getApplicationName() + " - Login";
    private static final String AUTH_TYPE_LABEL = "Authentifizierungsart";
    private static final String LOGIN_FORM_LABEL = "Zugangsdaten";
    private static final String ADVANCED_LABEL = "Erweitert";
    protected final JRadioButton[] rdoLoginType = new JRadioButton[3];
    protected final JComboBox<Organization> cboOrganization;
    protected final JTextField txtUsername;
    protected final JPasswordField txtPassword;
    protected final JCheckBox chkSaveUsername;
    protected final JButton btnOpenRegistration;
    protected final JButton btnLogin;
    protected final JPanel pnlLoginType;
    protected final JPanel pnlLoginForm;
    protected final JPanel pnlAdvanced;
    protected final JButton btnSettings;
    protected final JButton btnLogDir;

    public LoginWindowLayout(Frame modalParent) {
        super((Window)modalParent, TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        GridManager grid = new GridManager(this, 2);
        grid.add(new QLabel(this.getScaledLogo()), 2);
        grid.nextRow();
        this.rdoLoginType[0] = new JRadioButton("Authentifizierung \u00fcber ".concat(Branding.getMasterServerIdm()));
        this.rdoLoginType[1] = new JRadioButton("Test-Zugang mit festem Benutzer");
        this.rdoLoginType[2] = new JRadioButton("Direkter Zugang zum Satelliten");
        this.btnSettings = new JButton("Einstellungen");
        this.btnLogDir = new JButton("Logverzeichnis");
        this.cboOrganization = new ComboBox<Organization>(new ComboBox.ComboBoxRenderer<Organization>(){

            @Override
            public String renderItem(Organization item) {
                if (item == null) {
                    return null;
                }
                return item.getDisplayName();
            }

            @Override
            public String getEmptyText() {
                return "Wird geladen...";
            }
        });
        this.txtUsername = new JTextField();
        this.txtPassword = new JPasswordField();
        this.btnLogin = new JButton("Login");
        this.chkSaveUsername = new JCheckBox("Benutzername speichern");
        this.btnOpenRegistration = new JButton("Registrieren");
        this.pnlLoginType = this.makeLoginTypePanel();
        grid.add(this.pnlLoginType).expand(0.25, 1.0).fill(true, true);
        this.pnlLoginForm = this.makeLoginFormPanel();
        grid.add(this.pnlLoginForm, 1, 2).expand(0.75, 1.0).fill(true, true);
        grid.nextRow();
        this.pnlAdvanced = this.makeAdvancedPanel();
        grid.add(this.pnlAdvanced).expand(true, true).fill(true, true);
        grid.finish(false);
    }

    private JPanel makeLoginFormPanel() {
        JPanel loginFormPanel = new JPanel();
        loginFormPanel.setBorder(new TitledBorder(LOGIN_FORM_LABEL));
        GridManager grid = new GridManager(loginFormPanel, 4);
        grid.add(new QLabel("Identity Provider"));
        grid.add(this.cboOrganization, 3).expand(true, false).fill(true, false);
        grid.nextRow();
        grid.add(new QLabel("Benutzername"));
        grid.add(this.txtUsername, 3).expand(true, false).fill(true, false);
        grid.nextRow();
        grid.add(new QLabel("Passwort"));
        grid.add(this.txtPassword, 3).expand(true, false).fill(true, false);
        grid.nextRow();
        grid.add(Box.createGlue());
        grid.add(this.chkSaveUsername).expand(true, false);
        grid.add(this.btnOpenRegistration);
        grid.add(this.btnLogin);
        grid.nextRow();
        grid.finish(true);
        return loginFormPanel;
    }

    private JPanel makeLoginTypePanel() {
        JPanel loginTypePanel = new JPanel();
        loginTypePanel.setLayout(new BoxLayout(loginTypePanel, 3));
        loginTypePanel.setBorder(new TitledBorder(AUTH_TYPE_LABEL));
        ButtonGroup loginTypeButtonGroup = new ButtonGroup();
        for (int i = 0; i < this.rdoLoginType.length; ++i) {
            loginTypeButtonGroup.add(this.rdoLoginType[i]);
            loginTypePanel.add(this.rdoLoginType[i]);
        }
        return loginTypePanel;
    }

    private JPanel makeAdvancedPanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.setBorder(new TitledBorder(ADVANCED_LABEL));
        p.add(this.btnSettings);
        p.add(this.btnLogDir);
        return p;
    }

    private ImageIcon getScaledLogo() {
        try {
            ImageIcon image = ResourceLoader.getIcon("/img/service-logo.png");
            Rectangle screenSize = Gui.getMonitorFromRectangle(this.getBounds(), true).getDefaultConfiguration().getBounds();
            float scaleX = (float)screenSize.width / (float)image.getIconWidth();
            float scaleY = (float)screenSize.height / (float)image.getIconHeight();
            float scaling = scaleX < scaleY ? scaleX / 2.0f : scaleY / 2.0f;
            image = new ImageIcon(image.getImage().getScaledInstance((int)((float)image.getIconWidth() * scaling), (int)((float)image.getIconHeight() * scaling), 0));
            return image;
        }
        catch (Exception e) {
            LOGGER.warn("Cannot load image", e);
            return null;
        }
    }

    protected static enum LOGIN_TYPE {
        ECP(0),
        TEST_ACCOUNT(1),
        DIRECT_CONNECT(2);

        public final int id;

        private LOGIN_TYPE(int id) {
            this.id = id;
        }
    }
}

