/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.window;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.ImageSummaryRead;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.MainWindow;
import org.openslx.dozmod.gui.control.table.ImageTable;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.gui.helper.PopupMenu;
import org.openslx.dozmod.gui.window.ImageDetailsWindow;
import org.openslx.dozmod.gui.window.ImagePublishedWindow;
import org.openslx.dozmod.gui.window.LectureListWindow;
import org.openslx.dozmod.gui.window.layout.ImageListWindowLayout;
import org.openslx.dozmod.gui.wizard.ImageCreationWizard;
import org.openslx.dozmod.gui.wizard.LectureWizard;
import org.openslx.dozmod.permissions.ImagePerms;
import org.openslx.dozmod.thrift.ImageLocalDetailsActions;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.ThriftActions;
import org.openslx.dozmod.thrift.cache.LectureCache;
import org.openslx.util.QuickTimer;

public class ImageListWindow
extends ImageListWindowLayout
implements ThriftActions.DownloadCallback,
ThriftActions.DeleteCallback {
    private static final Logger LOGGER = Logger.getLogger(ImageListWindow.class);
    public final ImageListWindow me = this;
    public final ImageTable imageTable = this.ctlImageListViewer.getImageTable();
    private final JMenuItem popupItemNewLecture = new JMenuItem("Neue Veranstaltung");
    private final JMenuItem popupItemEdit = new JMenuItem("Detailansicht");
    private final JMenuItem popupItemDelete = new JMenuItem("L\u00f6schen");
    private final JMenuItem popupItemDownload = new JMenuItem("Download");

    public ImageListWindow() {
        final PopupMenu pop = new PopupMenu(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(ImageListWindow.this.popupItemNewLecture)) {
                    ImageListWindow.this.startLectureWizard((ImageSummaryRead)ImageListWindow.this.imageTable.getSelectedItem());
                }
                if (e.getSource().equals(ImageListWindow.this.popupItemEdit)) {
                    ImageListWindow.this.openImageDetails((ImageSummaryRead)ImageListWindow.this.imageTable.getSelectedItem());
                }
                if (e.getSource().equals(ImageListWindow.this.popupItemDownload)) {
                    ImageListWindow.this.performImageDownload((ImageSummaryRead)ImageListWindow.this.imageTable.getSelectedItem());
                }
                if (e.getSource().equals(ImageListWindow.this.popupItemDelete)) {
                    ImageListWindow.this.deleteImages(ImageListWindow.this.imageTable.getSelectedItems());
                }
            }
        });
        this.imageTable.setSelectionMode(2);
        pop.addMenuItem(this.popupItemNewLecture);
        pop.addMenuItem(this.popupItemEdit);
        pop.addMenuItem(this.popupItemDownload);
        pop.addSeparator();
        pop.addMenuItem(this.popupItemDelete);
        this.imageTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ImageSummaryRead item = (ImageSummaryRead)ImageListWindow.this.imageTable.getSelectedItem();
                ImageListWindow.this.updateAvailableOptions(item);
            }
        });
        this.imageTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 116) {
                    ImageListWindow.this.ctlImageListViewer.refreshList(true, 1);
                }
            }
        });
        this.imageTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    ImageListWindow.this.openImageDetails((ImageSummaryRead)ImageListWindow.this.imageTable.getSelectedItem());
                }
                this.processClick(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.processClick(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.processClick(e);
            }

            private void processClick(MouseEvent e) {
                int mouseRowIndex = ImageListWindow.this.imageTable.rowAtPoint(e.getPoint());
                boolean alreadySelectedRow = false;
                for (int i : ImageListWindow.this.imageTable.getSelectedRows()) {
                    if (i != mouseRowIndex) continue;
                    alreadySelectedRow = true;
                    break;
                }
                if (mouseRowIndex >= 0 && mouseRowIndex < ImageListWindow.this.imageTable.getRowCount() && SwingUtilities.isRightMouseButton(e)) {
                    if (!alreadySelectedRow) {
                        ImageListWindow.this.imageTable.setRowSelectionInterval(mouseRowIndex, mouseRowIndex);
                    }
                    if (e.isPopupTrigger()) {
                        pop.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
        this.btnNewVm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ImageCreationWizard(SwingUtilities.getWindowAncestor(ImageListWindow.this.me)).setVisible(true);
                ImageListWindow.this.ctlImageListViewer.refreshList(true, 100);
            }
        });
        this.btnNewLecture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageListWindow.this.startLectureWizard((ImageSummaryRead)ImageListWindow.this.imageTable.getSelectedItem());
            }
        });
        this.btnEditDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageListWindow.this.openImageDetails((ImageSummaryRead)ImageListWindow.this.imageTable.getSelectedItem());
            }
        });
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageListWindow.this.performImageDownload((ImageSummaryRead)ImageListWindow.this.imageTable.getSelectedItem());
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageListWindow.this.deleteImages(ImageListWindow.this.imageTable.getSelectedItems());
            }
        });
        this.btnShowPublishedImages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImagePublishedWindow.open(JOptionPane.getFrameForComponent(ImageListWindow.this.me));
            }
        });
        this.btnSwitchView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainWindow.showPage(LectureListWindow.class);
            }
        });
        this.imageTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "details");
        this.imageTable.getActionMap().put("details", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageListWindow.this.btnEditDetails.doClick();
            }
        });
        this.imageTable.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.imageTable.getActionMap().put("delete", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageListWindow.this.btnDelete.doClick();
            }
        });
        this.updateAvailableOptions(null);
    }

    private boolean hasLatestVersion(ImageSummaryRead image) {
        if (image == null) {
            return false;
        }
        if (image.getLatestVersionId() == null) {
            Gui.showMessageBox(this.me, "Die gew\u00e4hlte VM besitzt keine g\u00fcltige Image-Version", MessageType.ERROR, null, null);
            return false;
        }
        return true;
    }

    private void updateAvailableOptions(ImageSummaryRead item) {
        boolean isValid = item != null && item.getLatestVersionId() != null;
        int selCount = this.imageTable.getSelectedRows().length;
        boolean download = isValid && selCount == 1 && ImagePerms.canDownload(item);
        boolean link = isValid && selCount == 1 && ImagePerms.canLink(item);
        boolean delete = ImagePerms.canAdmin(item) || selCount > 1;
        this.btnDownload.setEnabled(download);
        this.btnNewLecture.setEnabled(link);
        this.btnDelete.setEnabled(delete);
        this.popupItemDownload.setEnabled(download);
        this.popupItemNewLecture.setEnabled(link);
        this.popupItemDelete.setEnabled(delete);
        this.btnEditDetails.setEnabled(selCount == 1);
        this.btnShowPublishedImages.setEnabled(true);
    }

    public void refresh(boolean force) {
        this.ctlImageListViewer.refreshList(force, 1);
    }

    private void startLectureWizard(ImageSummaryRead image) {
        if (!this.hasLatestVersion(image)) {
            return;
        }
        new LectureWizard(SwingUtilities.getWindowAncestor(this), image, image.getLatestVersionId()).setVisible(true);
    }

    private void openImageDetails(ImageSummaryRead image) {
        if (image == null) {
            return;
        }
        ImageDetailsWindow.open((JFrame)SwingUtilities.getWindowAncestor(this.me), image.getImageBaseId(), new ImageDetailsWindow.ImageUpdatedCallback(){

            @Override
            public void updated() {
                ImageListWindow.this.ctlImageListViewer.refreshList(true, 100);
            }
        }, new ImageLocalDetailsActions(JOptionPane.getFrameForComponent(this.me)));
    }

    private void performImageDownload(ImageSummaryRead image) {
        if (!this.hasLatestVersion(image)) {
            return;
        }
        this.btnDownload.setEnabled(false);
        ThriftActions.initDownload(JOptionPane.getFrameForComponent(this), image.latestVersionId, image.imageName, image.virtId, image.osId, image.fileSize, this);
    }

    @Override
    public void downloadInitialized(boolean success) {
        if (!success) {
            Gui.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImageListWindow.this.btnDownload.setEnabled(true);
                    ImageListWindow.this.ctlImageListViewer.refreshList(true, 1000);
                }
            });
        }
    }

    private void deleteBaseImage(ImageSummaryRead image) {
        ThriftActions.deleteImageBase(JOptionPane.getFrameForComponent(this), image.getImageBaseId());
    }

    private void deleteImages(List<ImageSummaryRead> imageList) {
        boolean failedToDeleteAll = false;
        boolean deletedAtLeastOne = false;
        StringBuilder builder = new StringBuilder();
        for (ImageSummaryRead image : imageList) {
            if (ImagePerms.canAdmin(image)) {
                this.deleteBaseImage(image);
                deletedAtLeastOne = true;
                continue;
            }
            failedToDeleteAll = true;
            builder.append('\n');
            builder.append(image.imageName);
        }
        if (failedToDeleteAll) {
            Gui.showMessageBox("Folgende images konnten nicht gel\u00f6scht werden: " + builder.toString(), MessageType.INFO, LOGGER, null);
        }
        this.ctlImageListViewer.refreshList(deletedAtLeastOne, 1000);
        QuickTimer.scheduleOnce(new QuickTimer.Task(){

            @Override
            public void fire() {
                LectureCache.get(true);
            }
        });
    }

    @Override
    public void isDeleted(boolean success) {
        this.ctlImageListViewer.refreshList(success, 1000);
    }

    @Override
    public boolean requestHide() {
        return true;
    }

    @Override
    public void requestShow() {
        this.ctlImageListViewer.refreshList(false, 1);
        this.btnShowPublishedImages.setVisible(Session.isImagePublishSupported());
    }
}

