/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.gui.activity;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.openslx.bwlp.thrift.iface.SscMode;
import org.openslx.bwlp.thrift.iface.TAuthorizationException;
import org.openslx.bwlp.thrift.iface.TInvalidTokenException;
import org.openslx.bwlp.thrift.iface.UploadOptions;
import org.openslx.dozmod.gui.Gui;
import org.openslx.dozmod.gui.activity.TransferPanel;
import org.openslx.dozmod.gui.helper.MessageType;
import org.openslx.dozmod.state.UploadWizardState;
import org.openslx.dozmod.thrift.Session;
import org.openslx.dozmod.thrift.UploadInitiator;
import org.openslx.sat.thrift.version.Feature;
import org.openslx.thrifthelper.ThriftManager;
import org.openslx.util.QuickTimer;

public class UploadPanel
extends TransferPanel {
    private static final Logger LOGGER = Logger.getLogger(UploadPanel.class);
    private final UploadInitiator state;
    private final UploadPanel panel = this;
    private final JCheckBox chkServerSideCopy;

    public UploadPanel(UploadWizardState state) {
        super(state.upload.getUploadTask(), state.name, state.diskFile.getName());
        if (!Session.hasFeature(Feature.SERVER_SIDE_COPY) || Session.getSatelliteConfig().serverSideCopy != SscMode.USER) {
            this.chkServerSideCopy = null;
        } else {
            this.chkServerSideCopy = new JCheckBox("ServerSide Copy");
            this.footer.add(Box.createHorizontalStrut(15));
            this.footer.add(this.chkServerSideCopy);
            this.chkServerSideCopy.addActionListener(new SscToggle());
        }
        this.btnClose.addActionListener(new ButtonAction());
        this.state = state.upload;
        state.upload.getUploadTask().addListener(this);
    }

    private class SscToggle
    implements ActionListener {
        private SscToggle() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final UploadOptions options = new UploadOptions(UploadPanel.this.chkServerSideCopy.isSelected());
            QuickTimer.scheduleOnce(new QuickTimer.Task(){

                @Override
                public void fire() {
                    boolean dis = false;
                    UploadOptions newOpt = null;
                    try {
                        newOpt = ThriftManager.getSatClient().setUploadOptions(Session.getSatelliteToken(), UploadPanel.this.state.getToken(), options);
                    }
                    catch (TAuthorizationException | TInvalidTokenException e) {
                        dis = true;
                    }
                    catch (TException e) {
                        Gui.asyncMessageBox("Unerwarteter Fehler beim Setzen der Transferoptionen", MessageType.ERROR, LOGGER, e);
                    }
                    final UploadOptions newOptions = newOpt;
                    final boolean disableBox = dis;
                    Gui.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            UploadPanel.this.chkServerSideCopy.setEnabled(!disableBox);
                            if (newOptions == null) {
                                UploadPanel.this.chkServerSideCopy.setSelected(!UploadPanel.this.chkServerSideCopy.isSelected());
                            } else if (newOptions.isSetServerSideCopying()) {
                                UploadPanel.this.chkServerSideCopy.setSelected(newOptions.serverSideCopying);
                            }
                            UploadPanel.this.progress.showOptimisticComplete(newOptions != null && newOptions.isSetServerSideCopying() && newOptions.serverSideCopying);
                        }
                    });
                }
            });
        }
    }

    private class ButtonAction
    implements ActionListener {
        private ButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!UploadPanel.this.state.getUploadTask().isCanceled()) {
                if (!Gui.showMessageBox(UploadPanel.this.panel, "Wollen Sie diesen Transfer wirklich abbrechen?", MessageType.QUESTION_YESNO, null, null)) {
                    return;
                }
                QuickTimer.scheduleOnce(new QuickTimer.Task(){

                    @Override
                    public void fire() {
                        UploadPanel.this.state.cancelError();
                    }
                });
            }
            UploadPanel.this.state.getUploadTask().removeListener(UploadPanel.this.panel);
            UploadPanel.this.close();
        }
    }
}

