/*
 * Decompiled with CFR 0.152.
 */
package org.openslx.dozmod.filetransfer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.log4j.Logger;
import org.openslx.bwlp.thrift.iface.TransferState;
import org.openslx.dozmod.filetransfer.TransferEvent;
import org.openslx.dozmod.filetransfer.TransferTask;
import org.openslx.filetransfer.DataReceivedCallback;
import org.openslx.filetransfer.Downloader;
import org.openslx.filetransfer.FileRange;
import org.openslx.filetransfer.Transfer;
import org.openslx.filetransfer.WantRangeCallback;
import org.openslx.filetransfer.util.ChunkList;
import org.openslx.filetransfer.util.FileChunk;
import org.openslx.util.Util;

public class DownloadTask
extends TransferTask {
    private static final Logger LOGGER = Logger.getLogger(DownloadTask.class);
    private final String host;
    private final int port;
    private final String downloadToken;
    private final RandomAccessFile fileHandle;
    private final ChunkList chunks;
    private final long startTime;
    private boolean fileWritable = true;

    public DownloadTask(String host, int port, String downloadToken, File destinationFile, long fileSize, List<byte[]> sha1Sums) throws FileNotFoundException {
        super(destinationFile, fileSize);
        this.host = host;
        this.port = port;
        this.downloadToken = downloadToken;
        this.fileHandle = new RandomAccessFile(destinationFile, "rw");
        this.chunks = new ChunkList(fileSize, sha1Sums);
        this.startTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCompletedChunk(FileChunk chunk, byte[] buffer) {
        if (chunk == null) {
            return;
        }
        try {
            RandomAccessFile randomAccessFile = this.fileHandle;
            synchronized (randomAccessFile) {
                this.fileHandle.seek(chunk.range.startOffset);
                this.fileHandle.write(buffer, 0, chunk.range.getLength());
            }
            this.chunks.markCompleted(chunk, true);
        }
        catch (Exception e) {
            LOGGER.error("Could not write to file at offset " + chunk.range.startOffset, e);
            this.fileWritable = false;
        }
    }

    @Override
    protected void cleanup() {
        Util.safeClose(this.fileHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TransferEvent getTransferEvent() {
        String error;
        TransferState state;
        byte[] progress = this.chunks.getStatusArray().array();
        if (this.consecutiveInitFails.get() > 20) {
            state = TransferState.ERROR;
            error = "Cannot talk to server after 20 tries...";
        } else if (this.chunks.isComplete() && this.getTransferCount() == 0) {
            Util.safeClose(this.fileHandle);
            state = TransferState.FINISHED;
            error = null;
        } else {
            state = TransferState.WORKING;
            error = null;
        }
        long speed = 0L;
        long timeRemaining = 0L;
        long virtualSpeed = 0L;
        List list = this.transfers;
        synchronized (list) {
            for (TransferTask.TransferThread thread : this.transfers) {
                speed += thread.getCurrentSpeed();
            }
        }
        if (progress != null) {
            int missing = 0;
            for (Object b : (Object)progress) {
                if (b == false) continue;
                ++missing;
            }
            long bytesRemaining = 0x1000000L * (long)missing;
            timeRemaining = 1000L * bytesRemaining / (speed + 1L);
            virtualSpeed = (long)(progress.length - missing) * 0x1000000L * 1000L / (System.currentTimeMillis() - this.startTime + 1L);
        }
        return new TransferEvent(state, progress, speed, virtualSpeed, timeRemaining, error);
    }

    @Override
    protected TransferTask.TransferThread createNewThread() {
        return new DownloadThread();
    }

    private class DownloadThread
    extends TransferTask.TransferThread {
        private Downloader downloader = null;
        private DownloadHandler cb = new DownloadHandler();

        private DownloadThread() {
        }

        @Override
        public void run() {
            try {
                this.downloader = new Downloader(DownloadTask.this.host, DownloadTask.this.port, 20000, null, DownloadTask.this.downloadToken);
            }
            catch (Exception e) {
                LOGGER.warn("Could not initialize new uploader", e);
                DownloadTask.this.consecutiveInitFails.incrementAndGet();
                DownloadTask.this.connectFailed(this);
                return;
            }
            DownloadTask.this.connectSucceeded(this);
            boolean ret = this.downloader.download(this.cb, (WantRangeCallback)this.cb);
            if (!ret) {
                DownloadTask.this.consecutiveInitFails.incrementAndGet();
            }
            if (this.cb.current != null) {
                DownloadTask.this.chunks.markFailed(this.cb.current);
            }
            DownloadTask.this.transferEnded(this, ret);
        }

        @Override
        protected Transfer getTransfer() {
            return this.downloader;
        }

        @Override
        public long getCurrentSpeed() {
            return this.cb.getCurrentSpeed();
        }
    }

    private class DownloadHandler
    implements WantRangeCallback,
    DataReceivedCallback {
        private FileChunk current = null;
        private byte[] buffer = null;
        private long currentSpeed = 0L;
        private long currentBytes = 0L;
        private long lastUpdate = 0L;
        private long lastBytes = 0L;

        private DownloadHandler() {
        }

        @Override
        public FileRange get() {
            DownloadTask.this.handleCompletedChunk(this.current, this.buffer);
            DownloadTask.this.consecutiveInitFails.lazySet(0);
            try {
                this.current = DownloadTask.this.chunks.getMissing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
            if (this.current == null) {
                return null;
            }
            this.buffer = new byte[this.current.range.getLength()];
            return this.current.range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean dataReceived(long fileOffset, int dataLength, byte[] data) {
            if (this.current == null) {
                throw new IllegalStateException("dataReceived without current chunk");
            }
            if (!this.current.range.contains(fileOffset, fileOffset + (long)dataLength)) {
                throw new IllegalStateException("dataReceived with file data out of range");
            }
            System.arraycopy(data, 0, this.buffer, (int)(fileOffset - this.current.range.startOffset), dataLength);
            this.currentBytes += (long)dataLength;
            long now = System.currentTimeMillis();
            if (this.lastUpdate + 600L < now) {
                DownloadHandler downloadHandler = this;
                synchronized (downloadHandler) {
                    this.lastBytes = (this.lastBytes * 2L + this.currentBytes) / 3L;
                    this.currentSpeed = 1000L * this.lastBytes / (now - this.lastUpdate);
                    this.lastUpdate = now;
                }
                this.currentBytes = 0L;
            }
            return DownloadTask.this.fileWritable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getCurrentSpeed() {
            DownloadHandler downloadHandler = this;
            synchronized (downloadHandler) {
                return this.currentSpeed;
            }
        }
    }
}

