/*
 * Decompiled with CFR 0.152.
 */
package org.jdatepicker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdatepicker.DateModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateModel<T>
implements DateModel<T> {
    public static final String PROPERTY_YEAR = "year";
    public static final String PROPERTY_MONTH = "month";
    public static final String PROPERTY_DAY = "day";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_SELECTED = "selected";
    private boolean selected = false;
    private Calendar calendarValue;
    private Set<ChangeListener> changeListeners = new HashSet<ChangeListener>();
    private Set<PropertyChangeListener> propertyChangeListeners = new HashSet<PropertyChangeListener>();

    protected AbstractDateModel() {
        this.calendarValue = Calendar.getInstance();
    }

    @Override
    public synchronized void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected synchronized void fireChangeEvent() {
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    protected synchronized void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        for (PropertyChangeListener listener : this.propertyChangeListeners) {
            listener.propertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue));
        }
    }

    @Override
    public int getDay() {
        return this.calendarValue.get(5);
    }

    @Override
    public int getMonth() {
        return this.calendarValue.get(2);
    }

    @Override
    public int getYear() {
        return this.calendarValue.get(1);
    }

    @Override
    public T getValue() {
        if (!this.selected) {
            return null;
        }
        return this.fromCalendar(this.calendarValue);
    }

    @Override
    public void setDay(int day) {
        int oldDayValue = this.calendarValue.get(5);
        T oldValue = this.getValue();
        this.calendarValue.set(5, day);
        this.fireChangeEvent();
        this.firePropertyChange(PROPERTY_DAY, oldDayValue, this.calendarValue.get(5));
        this.firePropertyChange(PROPERTY_VALUE, oldValue, this.getValue());
    }

    @Override
    public void addDay(int add) {
        int oldDayValue = this.calendarValue.get(5);
        T oldValue = this.getValue();
        this.calendarValue.add(5, add);
        this.fireChangeEvent();
        this.firePropertyChange(PROPERTY_DAY, oldDayValue, this.calendarValue.get(5));
        this.firePropertyChange(PROPERTY_VALUE, oldValue, this.getValue());
    }

    @Override
    public void setMonth(int month) {
        int oldYearValue = this.calendarValue.get(1);
        int oldMonthValue = this.calendarValue.get(2);
        int oldDayValue = this.calendarValue.get(5);
        T oldValue = this.getValue();
        Calendar newVal = Calendar.getInstance();
        newVal.set(5, 1);
        newVal.set(2, month);
        newVal.set(1, oldYearValue);
        if (newVal.getActualMaximum(5) <= oldDayValue) {
            newVal.set(5, newVal.getActualMaximum(5));
        } else {
            newVal.set(5, oldDayValue);
        }
        this.calendarValue.set(2, newVal.get(2));
        this.calendarValue.set(5, newVal.get(5));
        this.fireChangeEvent();
        this.firePropertyChange(PROPERTY_MONTH, oldMonthValue, this.calendarValue.get(2));
        if (this.calendarValue.get(5) != oldDayValue) {
            this.firePropertyChange(PROPERTY_DAY, oldDayValue, this.calendarValue.get(5));
        }
        this.firePropertyChange(PROPERTY_VALUE, oldValue, this.getValue());
    }

    @Override
    public void addMonth(int add) {
        int oldMonthValue = this.calendarValue.get(2);
        T oldValue = this.getValue();
        this.calendarValue.add(2, add);
        this.fireChangeEvent();
        this.firePropertyChange(PROPERTY_MONTH, oldMonthValue, this.calendarValue.get(2));
        this.firePropertyChange(PROPERTY_VALUE, oldValue, this.getValue());
    }

    @Override
    public void setYear(int year) {
        int oldYearValue = this.calendarValue.get(1);
        int oldMonthValue = this.calendarValue.get(2);
        int oldDayValue = this.calendarValue.get(5);
        T oldValue = this.getValue();
        Calendar newVal = Calendar.getInstance();
        newVal.set(5, 1);
        newVal.set(2, oldMonthValue);
        newVal.set(1, year);
        if (newVal.getActualMaximum(5) <= oldDayValue) {
            newVal.set(5, newVal.getActualMaximum(5));
        } else {
            newVal.set(5, oldDayValue);
        }
        this.calendarValue.set(1, newVal.get(1));
        this.calendarValue.set(5, newVal.get(5));
        this.fireChangeEvent();
        this.firePropertyChange(PROPERTY_YEAR, oldYearValue, this.calendarValue.get(1));
        if (this.calendarValue.get(5) != oldDayValue) {
            this.firePropertyChange(PROPERTY_DAY, oldDayValue, this.calendarValue.get(5));
        }
        this.firePropertyChange(PROPERTY_VALUE, oldValue, this.getValue());
    }

    @Override
    public void addYear(int add) {
        int oldYearValue = this.calendarValue.get(1);
        T oldValue = this.getValue();
        this.calendarValue.add(1, add);
        this.fireChangeEvent();
        this.firePropertyChange(PROPERTY_YEAR, oldYearValue, this.calendarValue.get(1));
        this.firePropertyChange(PROPERTY_VALUE, oldValue, this.getValue());
    }

    @Override
    public void setValue(T value) {
        int oldYearValue = this.calendarValue.get(1);
        int oldMonthValue = this.calendarValue.get(2);
        int oldDayValue = this.calendarValue.get(5);
        T oldValue = this.getValue();
        boolean oldSelectedValue = this.isSelected();
        if (value != null) {
            this.calendarValue = this.toCalendar(value);
            this.setToMidnight();
            this.selected = true;
        } else {
            this.selected = false;
        }
        this.fireChangeEvent();
        this.firePropertyChange(PROPERTY_YEAR, oldYearValue, this.calendarValue.get(1));
        this.firePropertyChange(PROPERTY_MONTH, oldMonthValue, this.calendarValue.get(2));
        this.firePropertyChange(PROPERTY_DAY, oldDayValue, this.calendarValue.get(5));
        this.firePropertyChange(PROPERTY_VALUE, oldValue, this.getValue());
        this.firePropertyChange(PROPERTY_SELECTED, oldSelectedValue, this.selected);
    }

    @Override
    public void setDate(int year, int month, int day) {
        int oldYearValue = this.calendarValue.get(1);
        int oldMonthValue = this.calendarValue.get(2);
        int oldDayValue = this.calendarValue.get(5);
        T oldValue = this.getValue();
        this.calendarValue.set(year, month, day);
        this.fireChangeEvent();
        this.firePropertyChange(PROPERTY_YEAR, oldYearValue, this.calendarValue.get(1));
        this.firePropertyChange(PROPERTY_MONTH, oldMonthValue, this.calendarValue.get(2));
        this.firePropertyChange(PROPERTY_DAY, oldDayValue, this.calendarValue.get(5));
        this.firePropertyChange(PROPERTY_VALUE, oldValue, this.getValue());
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        T oldValue = this.getValue();
        boolean oldSelectedValue = this.isSelected();
        this.selected = selected;
        this.fireChangeEvent();
        this.firePropertyChange(PROPERTY_VALUE, oldValue, this.getValue());
        this.firePropertyChange(PROPERTY_SELECTED, oldSelectedValue, this.selected);
    }

    private void setToMidnight() {
        this.calendarValue.set(10, 0);
        this.calendarValue.set(12, 0);
        this.calendarValue.set(13, 0);
        this.calendarValue.set(14, 0);
    }

    protected abstract Calendar toCalendar(T var1);

    protected abstract T fromCalendar(Calendar var1);
}

